/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.deltaspike.core.util.ClassUtils;

@Typed
public abstract class JndiUtils {
    private static final Logger LOG = Logger.getLogger(JndiUtils.class.getName());
    private static InitialContext initialContext = null;

    private JndiUtils() {
    }

    public static <T> T lookup(String name, Class<? extends T> targetType) {
        try {
            block11: {
                Object result = initialContext.lookup(name);
                if (result != null) {
                    if (targetType.isAssignableFrom(result.getClass())) {
                        return (T)result;
                    }
                    if (result instanceof String) {
                        try {
                            Class classOfResult = ClassUtils.loadClassForName((String)((String)result));
                            if (targetType.isAssignableFrom(classOfResult)) {
                                try {
                                    return classOfResult.newInstance();
                                }
                                catch (Exception e) {
                                    LOG.log(Level.SEVERE, "Class " + classOfResult + " from JNDI lookup for name " + name + " could not be instantiated", e);
                                    break block11;
                                }
                            }
                            LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " returned class " + classOfResult.getName() + " which does not implement/extend the expected class" + targetType.getName());
                        }
                        catch (ClassNotFoundException cnfe) {
                            LOG.log(Level.SEVERE, "Could not find Class " + result + " from JNDI lookup for name " + name, cnfe);
                        }
                    } else {
                        LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " should return a value of " + targetType + ", but returned " + result);
                    }
                }
            }
            return null;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Could not get " + name + " from JNDI", e);
        }
    }

    static {
        try {
            initialContext = new InitialContext();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

