/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.annotation.ConfigProperty;
import org.apache.deltaspike.core.spi.config.BaseConfigPropertyProducer;

@ApplicationScoped
public class DefaultConfigPropertyProducer
extends BaseConfigPropertyProducer {
    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public String produceStringConfiguration(InjectionPoint injectionPoint) {
        return this.getStringPropertyValue(injectionPoint);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Integer produceIntegerConfiguration(InjectionPoint injectionPoint) {
        String configuredValue = this.getStringPropertyValue(injectionPoint);
        if (configuredValue == null) {
            return null;
        }
        try {
            return Integer.parseInt(configuredValue);
        }
        catch (NumberFormatException nfe) {
            ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(injectionPoint, ConfigProperty.class);
            throw new RuntimeException("Error while converting Integer property '" + configProperty.name() + "' value: " + configuredValue + " happening in bean " + injectionPoint.getBean(), nfe);
        }
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Long produceLongConfiguration(InjectionPoint injectionPoint) {
        String configuredValue = this.getStringPropertyValue(injectionPoint);
        if (configuredValue == null) {
            return null;
        }
        try {
            return Long.parseLong(configuredValue);
        }
        catch (NumberFormatException nfe) {
            ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(injectionPoint, ConfigProperty.class);
            throw new RuntimeException("Error while converting Long property '" + configProperty.name() + "' value: " + configuredValue + " happening in bean " + injectionPoint.getBean(), nfe);
        }
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Boolean produceBooleanConfiguration(InjectionPoint injectionPoint) {
        String configuredValue = this.getStringPropertyValue(injectionPoint);
        if (configuredValue == null) {
            return null;
        }
        Boolean isTrue = "TRUE".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "1".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "YES".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "Y".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "JA".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "J".equalsIgnoreCase(configuredValue);
        isTrue = isTrue | "OUI".equalsIgnoreCase(configuredValue);
        return isTrue;
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Float produceFloatConfiguration(InjectionPoint injectionPoint) {
        String configuredValue = this.getStringPropertyValue(injectionPoint);
        if (configuredValue == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(configuredValue));
        }
        catch (NumberFormatException nfe) {
            ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(injectionPoint, ConfigProperty.class);
            throw new RuntimeException("Error while converting Float property '" + configProperty.name() + "' value: " + configuredValue + " happening in bean " + injectionPoint.getBean(), nfe);
        }
    }
}

