/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.deltaspike.core.api.exception.control.event.ExceptionEvent;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.impl.exception.control.HandlerMethodImpl;
import org.apache.deltaspike.core.util.metadata.builder.ParameterValueRedefiner;

class OutboundParameterValueRedefiner
implements ParameterValueRedefiner {
    private final ExceptionEvent<?> event;
    private final Bean<?> declaringBean;
    private final HandlerMethodImpl<?> handlerMethod;

    OutboundParameterValueRedefiner(ExceptionEvent<?> event, HandlerMethodImpl<?> handlerMethod) {
        this.event = event;
        this.declaringBean = handlerMethod.getBean();
        this.handlerMethod = handlerMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object redefineParameterValue(ParameterValueRedefiner.ParameterValue value) {
        CreationalContext ctx = BeanManagerProvider.getInstance().getBeanManager().createCreationalContext(this.declaringBean);
        try {
            if (value.getPosition() == this.handlerMethod.getHandlerParameter().getPosition()) {
                ExceptionEvent<?> exceptionEvent = this.event;
                return exceptionEvent;
            }
            Object object = value.getDefaultValue(ctx);
            return object;
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }
}

