/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exclude.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.Nonbinding;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.exclude.annotation.Exclude;
import org.apache.deltaspike.core.api.interpreter.ExpressionInterpreter;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.impl.exclude.CustomProjectStageBeanFilter;
import org.apache.deltaspike.core.impl.exclude.GlobalAlternative;
import org.apache.deltaspike.core.impl.interpreter.PropertyExpressionInterpreter;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class ExcludeExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ExcludeExtension.class.getName());
    private static Boolean isOwbDetected = false;
    private boolean isActivated = true;
    private boolean isGlobalAlternativeActivated = true;
    private boolean isCustomProjectStageBeanFilterActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        this.isGlobalAlternativeActivated = ClassDeactivationUtils.isActivated(GlobalAlternative.class);
        this.isCustomProjectStageBeanFilterActivated = ClassDeactivationUtils.isActivated(CustomProjectStageBeanFilter.class);
        isOwbDetected = this.isOpenWebBeans();
    }

    protected void initProjectStage(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        ProjectStageProducer.getInstance();
    }

    protected void vetoBeans(@Observes ProcessAnnotatedType processAnnotatedType, BeanManager beanManager) {
        if (this.isGlobalAlternativeActivated) {
            if (isOwbDetected.booleanValue()) {
                this.activateGlobalAlternativesOwb(processAnnotatedType, beanManager);
            } else {
                this.activateGlobalAlternativesWeld(processAnnotatedType, beanManager);
            }
        }
        if (this.isCustomProjectStageBeanFilterActivated) {
            this.vetoCustomProjectStageBeans(processAnnotatedType);
        }
        if (!this.isActivated) {
            return;
        }
        ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
        if (!processAnnotatedType.getAnnotatedType().getJavaClass().isAnnotationPresent(Exclude.class)) {
            return;
        }
        Exclude exclude = processAnnotatedType.getAnnotatedType().getJavaClass().getAnnotation(Exclude.class);
        if (!this.evalExcludeWithoutCondition(processAnnotatedType, exclude)) {
            return;
        }
        if (!this.evalExcludeInProjectStage(processAnnotatedType, exclude, projectStage)) {
            return;
        }
        if (!this.evalExcludeNotInProjectStage(processAnnotatedType, exclude, projectStage)) {
            return;
        }
        this.evalExcludeWithExpression(processAnnotatedType, exclude);
    }

    protected void vetoCustomProjectStageBeans(ProcessAnnotatedType processAnnotatedType) {
        if (ProjectStage.class.isAssignableFrom(processAnnotatedType.getAnnotatedType().getJavaClass())) {
            processAnnotatedType.veto();
        }
    }

    private void activateGlobalAlternativesWeld(ProcessAnnotatedType processAnnotatedType, BeanManager beanManager) {
        Class currentBean = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (currentBean.isInterface()) {
            return;
        }
        Set<Class> beanBaseTypes = this.resolveBeanTypes(currentBean);
        boolean isAlternativeBeanImplementation = currentBean.isAnnotationPresent(Alternative.class);
        List<Annotation> qualifiersOfCurrentBean = this.resolveQualifiers(processAnnotatedType.getAnnotatedType().getAnnotations(), beanManager);
        for (Class currentType : beanBaseTypes) {
            HashSet<Annotation> alternativeBeanAnnotations = new HashSet<Annotation>();
            String configuredBeanName = ConfigResolver.getPropertyValue((String)currentType.getName());
            if (configuredBeanName == null || configuredBeanName.length() <= 0) continue;
            Class alternativeBeanClass = ClassUtils.tryToLoadClassForName((String)configuredBeanName);
            if (alternativeBeanClass == null) {
                throw new IllegalStateException("Can't find class " + configuredBeanName + " which is configured" + " for " + currentType.getName());
            }
            if (!alternativeBeanClass.isAnnotationPresent(Alternative.class)) continue;
            alternativeBeanAnnotations.addAll(Arrays.asList(alternativeBeanClass.getAnnotations()));
            List<Annotation> qualifiersOfConfiguredBean = this.resolveQualifiers(alternativeBeanAnnotations, beanManager);
            if (isAlternativeBeanImplementation) {
                if (!this.doQualifiersMatch(qualifiersOfCurrentBean, qualifiersOfConfiguredBean)) continue;
                AnnotatedTypeBuilder annotatedTypeBuilder = new AnnotatedTypeBuilder().readFromType(processAnnotatedType.getAnnotatedType());
                annotatedTypeBuilder.removeFromClass(Alternative.class);
                processAnnotatedType.setAnnotatedType(annotatedTypeBuilder.create());
                return;
            }
            if (!this.doQualifiersMatch(qualifiersOfCurrentBean, qualifiersOfConfiguredBean)) continue;
            processAnnotatedType.veto();
            return;
        }
    }

    private void activateGlobalAlternativesOwb(ProcessAnnotatedType processAnnotatedType, BeanManager beanManager) {
        Class currentBean = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (currentBean.isInterface()) {
            return;
        }
        Set<Class> beanBaseTypes = this.resolveBeanTypes(currentBean);
        boolean isAlternativeBeanImplementation = currentBean.isAnnotationPresent(Alternative.class);
        List<Annotation> qualifiersOfCurrentBean = this.resolveQualifiers(processAnnotatedType.getAnnotatedType().getAnnotations(), beanManager);
        for (Class currentType : beanBaseTypes) {
            HashSet<Annotation> alternativeBeanAnnotations = new HashSet<Annotation>();
            String configuredBeanName = ConfigResolver.getPropertyValue((String)currentType.getName());
            if (configuredBeanName == null || configuredBeanName.length() <= 0) continue;
            Class alternativeBeanClass = ClassUtils.tryToLoadClassForName((String)configuredBeanName);
            if (alternativeBeanClass == null) {
                throw new IllegalStateException("Can't find class " + configuredBeanName + " which is configured" + " for " + currentType.getName());
            }
            alternativeBeanAnnotations.addAll(Arrays.asList(alternativeBeanClass.getAnnotations()));
            List<Annotation> qualifiersOfConfiguredBean = this.resolveQualifiers(alternativeBeanAnnotations, beanManager);
            if (isAlternativeBeanImplementation) {
                if (!this.doQualifiersMatch(qualifiersOfCurrentBean, qualifiersOfConfiguredBean)) continue;
                processAnnotatedType.veto();
                break;
            }
            if (!alternativeBeanClass.isAnnotationPresent(Alternative.class) || !this.doQualifiersMatch(qualifiersOfCurrentBean, qualifiersOfConfiguredBean)) continue;
            AnnotatedTypeBuilder annotatedTypeBuilder = new AnnotatedTypeBuilder().readFromType(alternativeBeanClass);
            annotatedTypeBuilder.removeFromClass(Alternative.class);
            processAnnotatedType.setAnnotatedType(annotatedTypeBuilder.create());
        }
    }

    private boolean doQualifiersMatch(List<Annotation> qualifiersOfCurrentBean, List<Annotation> qualifiersOfConfiguredBean) {
        if (qualifiersOfCurrentBean.size() != qualifiersOfConfiguredBean.size()) {
            return false;
        }
        int matchingQualifiers = 0;
        block0: for (Annotation currentQualifier : qualifiersOfCurrentBean) {
            for (Annotation qualifierConfiguredBean : qualifiersOfConfiguredBean) {
                if (!this.doesQualifierMatch(currentQualifier, qualifierConfiguredBean)) continue;
                ++matchingQualifiers;
                continue block0;
            }
        }
        return qualifiersOfConfiguredBean.size() == matchingQualifiers;
    }

    private boolean doesQualifierMatch(Annotation currentQualifier, Annotation qualifierConfiguredBean) {
        if (!currentQualifier.annotationType().equals(qualifierConfiguredBean.annotationType())) {
            return false;
        }
        for (Method currentMethod : currentQualifier.annotationType().getDeclaredMethods()) {
            if (currentMethod.isAnnotationPresent(Nonbinding.class)) continue;
            try {
                currentMethod.setAccessible(true);
                Object currentValue = currentMethod.invoke((Object)currentQualifier, new Object[0]);
                Object valueOfQualifierConfiguredBean = currentMethod.invoke((Object)qualifierConfiguredBean, new Object[0]);
                if (currentValue.equals(valueOfQualifierConfiguredBean)) continue;
                return false;
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't compare " + currentQualifier.annotationType().getName() + " with " + qualifierConfiguredBean.annotationType().getName());
            }
        }
        return true;
    }

    private List<Annotation> resolveQualifiers(Set<Annotation> annotations, BeanManager beanManager) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            result.add(annotation);
        }
        return result;
    }

    private Set<Class> resolveBeanTypes(Class beanClass) {
        HashSet<Class> result = new HashSet<Class>();
        for (Class currentClass = beanClass; currentClass != null && !Object.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
            result.add(currentClass);
            for (Class<?> interfaceClass : currentClass.getInterfaces()) {
                if (interfaceClass.getName().startsWith("java.") || interfaceClass.getName().startsWith("javax.")) continue;
                result.addAll(this.resolveBeanTypes(interfaceClass));
            }
        }
        return result;
    }

    private boolean evalExcludeWithoutCondition(ProcessAnnotatedType processAnnotatedType, Exclude exclude) {
        if (exclude.ifProjectStage().length == 0 && exclude.exceptIfProjectStage().length == 0 && "".equals(exclude.onExpression())) {
            this.veto(processAnnotatedType, "Stateless");
            return false;
        }
        return true;
    }

    private boolean evalExcludeInProjectStage(ProcessAnnotatedType processAnnotatedType, Exclude exclude, ProjectStage currentlyConfiguredProjectStage) {
        Class[] activatedIn = exclude.ifProjectStage();
        if (activatedIn.length == 0) {
            return true;
        }
        if (this.isInProjectStage(activatedIn, currentlyConfiguredProjectStage)) {
            this.veto(processAnnotatedType, "IfProjectState");
            return false;
        }
        return true;
    }

    private boolean evalExcludeNotInProjectStage(ProcessAnnotatedType processAnnotatedType, Exclude exclude, ProjectStage currentlyConfiguredProjectStage) {
        Class[] notIn = exclude.exceptIfProjectStage();
        if (notIn.length == 0) {
            return true;
        }
        if (!this.isInProjectStage(notIn, currentlyConfiguredProjectStage)) {
            this.veto(processAnnotatedType, "ExceptIfProjectState");
            return false;
        }
        return true;
    }

    private void evalExcludeWithExpression(ProcessAnnotatedType processAnnotatedType, Exclude exclude) {
        if ("".equals(exclude.onExpression())) {
            return;
        }
        if (this.isDeactivated(exclude, PropertyExpressionInterpreter.class)) {
            this.veto(processAnnotatedType, "Expression");
        }
    }

    private boolean isInProjectStage(Class<? extends ProjectStage>[] activatedIn, ProjectStage currentlyConfiguredProjectStage) {
        if (activatedIn != null && activatedIn.length > 0) {
            for (Class<? extends ProjectStage> activated : activatedIn) {
                if (!currentlyConfiguredProjectStage.getClass().equals(activated)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeactivated(Exclude exclude, Class defaultExpressionInterpreterClass) {
        ExpressionInterpreter expressionInterpreter;
        String expressions = exclude.onExpression();
        Class interpreterClass = exclude.interpretedBy();
        if (interpreterClass.equals(ExpressionInterpreter.class)) {
            interpreterClass = defaultExpressionInterpreterClass;
        }
        if ((expressionInterpreter = (ExpressionInterpreter)ClassUtils.tryToInstantiateClass((Class)interpreterClass)) == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("can't instantiate " + interpreterClass.getClass().getName());
            }
            return true;
        }
        return (Boolean)expressionInterpreter.evaluate((Object)expressions);
    }

    private void veto(ProcessAnnotatedType processAnnotatedType, String vetoType) {
        processAnnotatedType.veto();
        LOG.finer(vetoType + " based veto for bean with type: " + processAnnotatedType.getAnnotatedType().getJavaClass());
    }

    private boolean isOpenWebBeans() {
        IllegalStateException runtimeException = new IllegalStateException();
        for (StackTraceElement element : runtimeException.getStackTrace()) {
            if (!element.toString().contains("org.apache.webbeans.")) continue;
            return true;
        }
        return false;
    }
}

