/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.context.Dependent;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.util.PropertyFileUtils;

@Dependent
public class DefaultMessageResolver
implements MessageResolver {
    private static final long serialVersionUID = 5834411208472341006L;

    public String getMessage(MessageContext messageContext, String messageTemplate) {
        if (messageTemplate.startsWith("{{")) {
            return messageTemplate.substring(1);
        }
        if (messageTemplate.startsWith("{") && messageTemplate.endsWith("}")) {
            String resourceKey = messageTemplate.substring(1, messageTemplate.length() - 1);
            List messageSources = messageContext.getMessageSources();
            if (messageSources == null || messageSources.isEmpty()) {
                return null;
            }
            Iterator messageSourceIterator = messageSources.iterator();
            while (messageSourceIterator.hasNext()) {
                String currentMessageSource = (String)messageSourceIterator.next();
                try {
                    Locale locale = messageContext.getLocale();
                    ResourceBundle messageBundle = PropertyFileUtils.getResourceBundle((String)currentMessageSource, (Locale)locale);
                    return messageBundle.getString(resourceKey);
                }
                catch (MissingResourceException e) {
                    if (messageSourceIterator.hasNext()) continue;
                    return null;
                }
            }
        }
        return messageTemplate;
    }
}

