/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.api.message.annotation.MessageContextConfig;
import org.apache.deltaspike.core.api.message.annotation.MessageTemplate;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;

class MessageBundleInvocationHandler
implements InvocationHandler {
    MessageBundleInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MessageTemplate messageTemplate = method.getAnnotation(MessageTemplate.class);
        String messageTemplateValue = messageTemplate != null ? messageTemplate.value() : "{" + method.getName() + "}";
        MessageContext messageContext = this.resolveMessageContextFromArguments(args);
        List<Serializable> arguments = this.resolveMessageArguments(args);
        if (messageContext == null) {
            messageContext = this.getDefaultMessageContext().clone();
            MessageContextConfig messageContextConfig = method.getDeclaringClass().getAnnotation(MessageContextConfig.class);
            if (messageContextConfig != null) {
                this.applyMessageContextConfig(messageContext, messageContextConfig);
            }
        }
        String messageBundleName = method.getDeclaringClass().getName();
        Message message = messageContext.messageSource(new String[]{messageBundleName}).message().template(messageTemplateValue).argument(arguments.toArray(new Serializable[arguments.size()]));
        if (String.class.isAssignableFrom(method.getReturnType())) {
            return message.toString();
        }
        return message;
    }

    private void applyMessageContextConfig(MessageContext messageContext, MessageContextConfig messageContextConfig) {
        if (!MessageResolver.class.equals((Object)messageContextConfig.messageResolver())) {
            Class messageResolverClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.messageResolver().getName());
            messageContext.messageResolver((MessageResolver)BeanProvider.getContextualReference((Class)messageResolverClass, (Annotation[])new Annotation[]{new AnyLiteral()}));
        }
        if (!MessageInterpolator.class.equals((Object)messageContextConfig.messageInterpolator())) {
            Class messageInterpolatorClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.messageInterpolator().getName());
            messageContext.messageInterpolator((MessageInterpolator)BeanProvider.getContextualReference((Class)messageInterpolatorClass, (Annotation[])new Annotation[]{new AnyLiteral()}));
        }
        if (!LocaleResolver.class.equals((Object)messageContextConfig.localeResolver())) {
            Class localeResolverClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.localeResolver().getName());
            messageContext.localeResolver((LocaleResolver)BeanProvider.getContextualReference((Class)localeResolverClass, (Annotation[])new Annotation[]{new AnyLiteral()}));
        }
        String[] messageSources = messageContextConfig.messageSource();
        messageContext.messageSource(messageSources);
    }

    private List<Serializable> resolveMessageArguments(Object[] args) {
        ArrayList<Serializable> arguments = new ArrayList<Serializable>();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i == 0 && MessageContext.class.isAssignableFrom(args[0].getClass())) continue;
                if (arg instanceof Serializable) {
                    arguments.add((Serializable)arg);
                    continue;
                }
                arguments.add((Serializable)((Object)arg.toString()));
            }
        }
        return arguments;
    }

    private MessageContext resolveMessageContextFromArguments(Object[] args) {
        if (args != null && args.length > 0 && MessageContext.class.isAssignableFrom(args[0].getClass())) {
            return (MessageContext)args[0];
        }
        return null;
    }

    private MessageContext getDefaultMessageContext() {
        return (MessageContext)BeanProvider.getContextualReference(MessageContext.class, (Annotation[])new Annotation[0]);
    }
}

