/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageBundle;
import org.apache.deltaspike.core.api.message.MessageTemplate;
import org.apache.deltaspike.core.impl.message.TypedMessageBundle;
import org.apache.deltaspike.core.impl.message.TypedMessageBundleProducer;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.bean.WrappingBeanBuilder;

public class MessageBundleExtension
implements Extension,
Deactivatable {
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> bundleProducerBean;
    private List<String> deploymentErrors = new ArrayList<String>();
    private Boolean isActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    protected void detectInterfaces(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        AnnotatedType type = processAnnotatedType.getAnnotatedType();
        if (type.isAnnotationPresent(MessageBundle.class) && this.validateMessageBundle(type.getJavaClass())) {
            this.messageBundleTypes.add(type);
        }
    }

    private boolean validateMessageBundle(Class<?> currentClass) {
        boolean ok = true;
        if (!currentClass.isInterface()) {
            this.deploymentErrors.add("@MessageBundle must only be used on Interfaces, but got used on class " + currentClass.getName());
            return false;
        }
        for (Method currentMethod : currentClass.getDeclaredMethods()) {
            if (!currentMethod.isAnnotationPresent(MessageTemplate.class) || String.class.isAssignableFrom(currentMethod.getReturnType()) || Message.class.isAssignableFrom(currentMethod.getReturnType())) continue;
            this.deploymentErrors.add(currentMethod.getReturnType().getName() + " isn't supported. Details: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + " only " + String.class.getName() + " or " + Message.class.getName());
            ok = false;
        }
        return ok;
    }

    protected void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageBundleProducer> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    protected void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageBundleProducer, Object> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    protected void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (method.isAnnotationPresent(TypedMessageBundle.class)) {
            this.bundleProducerBean = bean;
        }
    }

    protected void installMessageBundleProducerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (!this.deploymentErrors.isEmpty()) {
            abd.addDefinitionError((Throwable)new IllegalArgumentException("The following MessageBundle problems where found: " + Arrays.toString(this.deploymentErrors.toArray())));
            return;
        }
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            abd.addBean(MessageBundleExtension.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
        }
    }

    private static <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> annotatedType, BeanManager beanManager) {
        WrappingBeanBuilder beanBuilder = new WrappingBeanBuilder(delegate, beanManager).readFromType(annotatedType);
        beanBuilder.types(new Type[]{annotatedType.getJavaClass(), Object.class, Serializable.class});
        return beanBuilder.create();
    }

    protected void cleanup(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.messageBundleTypes.clear();
    }
}

