/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.scope.window;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

@SessionScoped
public class WindowBeanHolder
implements Serializable {
    private Map<String, ContextualStorage> storageMap = new ConcurrentHashMap<String, ContextualStorage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextualStorage getContextualStorage(BeanManager beanManager, String windowId) {
        ContextualStorage contextualStorage = this.storageMap.get(windowId);
        if (contextualStorage == null) {
            WindowBeanHolder windowBeanHolder = this;
            synchronized (windowBeanHolder) {
                contextualStorage = this.storageMap.get(windowId);
                if (contextualStorage == null) {
                    this.storageMap.put(windowId, new ContextualStorage(beanManager, true, true));
                }
            }
        }
        return contextualStorage;
    }

    public Map<String, ContextualStorage> getStorageMap() {
        return this.storageMap;
    }

    public Map<String, ContextualStorage> forceNewStorage() {
        Map<String, ContextualStorage> oldStorageMap = this.storageMap;
        this.storageMap = new ConcurrentHashMap<String, ContextualStorage>();
        return oldStorageMap;
    }

    @PreDestroy
    public void destroyBeans() {
        Map<String, ContextualStorage> oldWindowContextStorages = this.forceNewStorage();
        for (ContextualStorage contextualStorage : oldWindowContextStorages.values()) {
            AbstractContext.destroyAllActive((ContextualStorage)contextualStorage);
        }
    }
}

