/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.impl.message.MessageBundleContext;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;
import org.apache.deltaspike.core.impl.message.NamedMessageBundleInvocationHandler;
import org.apache.deltaspike.core.impl.message.NamedTypedMessageBundle;
import org.apache.deltaspike.core.impl.message.TypedMessageBundle;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;

public class TypedMessageBundleProducer
implements Serializable {
    private static final long serialVersionUID = -5077306523543940760L;
    private static final String JAVA_PACKAGE = "java.";

    @Produces
    @Dependent
    @TypedMessageBundle
    Object produceTypedMessageBundle(InjectionPoint injectionPoint, MessageBundleInvocationHandler handler) {
        return this.createMessageBundleProxy(ReflectionUtils.getRawType((Type)injectionPoint.getType()), handler);
    }

    @Produces
    @Dependent
    @NamedTypedMessageBundle
    Object produceTypedMessageBundle(NamedMessageBundleInvocationHandler handler) {
        Bean currentMessageBundleContextBean = MessageBundleContext.getCurrentMessageBundleBean();
        Class<?> type = this.extractCustomType(currentMessageBundleContextBean);
        handler.setTargetType(type);
        return this.createMessageBundleProxy(type, handler);
    }

    private Class<?> extractCustomType(Bean currentMessageBundleBean) {
        for (Object type : currentMessageBundleBean.getTypes()) {
            if (!(type instanceof Class) || ((Class)type).getName().startsWith(JAVA_PACKAGE)) continue;
            return (Class)type;
        }
        throw new IllegalStateException("no custom type found for bean: " + currentMessageBundleBean.toString());
    }

    private <T> T createMessageBundleProxy(Class<T> type, MessageBundleInvocationHandler handler) {
        return type.cast(Proxy.newProxyInstance(ClassUtils.getClassLoader(null), new Class[]{type}, (InvocationHandler)handler));
    }
}

