/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.jmx;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.jmx.JmxBroadcaster;
import org.apache.deltaspike.core.api.jmx.MBean;
import org.apache.deltaspike.core.impl.jmx.DynamicMBeanWrapper;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.BeanUtils;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class MBeanExtension
implements Extension,
Deactivatable {
    private static final Logger LOGGER = Logger.getLogger(MBeanExtension.class.getName());
    private final Map<Class<?>, DynamicMBeanWrapper> wrappers = new ConcurrentHashMap();
    private final Collection<ObjectName> objectNames = new ArrayList<ObjectName>();
    private Boolean isActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    protected void processBean(@Observes ProcessManagedBean<?> bean, BeanManager bm) throws Exception {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        MBean mBeanAnnotation = (MBean)bean.getAnnotated().getAnnotation(MBean.class);
        if (mBeanAnnotation != null) {
            this.registerObject(bean, mBeanAnnotation, bm);
        }
    }

    protected void shutdown(@Observes BeforeShutdown shutdown) throws Exception {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        MBeanServer mBeanServer = this.mBeanServer();
        for (ObjectName objectName : this.objectNames) {
            mBeanServer.unregisterMBean(objectName);
            LOGGER.info("Unregistered MBean " + objectName.getCanonicalName());
        }
        this.objectNames.clear();
    }

    private void registerObject(ProcessManagedBean<?> bean, MBean mBeanAnnotation, BeanManager bm) throws Exception {
        Class clazz = bean.getAnnotatedBeanClass().getJavaClass();
        String objectNameValue = mBeanAnnotation.objectName();
        if (objectNameValue.isEmpty()) {
            String category;
            String name = mBeanAnnotation.name();
            if (name.isEmpty()) {
                name = clazz.getName();
            }
            if ((category = mBeanAnnotation.category().trim()).startsWith("{") && category.endsWith("}")) {
                category = ConfigResolver.getPropertyValue((String)category.substring(1, category.length() - 1), (String)"org.apache.deltaspike");
            }
            objectNameValue = category + ":type=MBeans,name=" + name;
        }
        ObjectName objectName = new ObjectName(objectNameValue);
        boolean normalScoped = this.isNormalScope(bean.getAnnotated().getAnnotations(), bm);
        Annotation[] qualifiers = this.qualifiers(bean.getAnnotatedBeanClass(), bm);
        DynamicMBeanWrapper mbean = new DynamicMBeanWrapper(clazz, normalScoped, qualifiers);
        MBeanServer server = this.mBeanServer();
        if (server.isRegistered(objectName) && "true".equals(ConfigResolver.getPropertyValue((String)"deltaspike.mbean.auto-unregister", (String)"true"))) {
            server.unregisterMBean(objectName);
        }
        server.registerMBean(mbean, objectName);
        this.objectNames.add(objectName);
        this.wrappers.put(clazz, mbean);
        LOGGER.info("Registered MBean " + objectName.getCanonicalName());
    }

    private Annotation[] qualifiers(AnnotatedType<?> annotatedBeanClass, BeanManager bm) {
        Set qualifiers = BeanUtils.getQualifiers((BeanManager)bm, (Iterable)annotatedBeanClass.getAnnotations());
        return qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    private boolean isNormalScope(Set<Annotation> annotations, BeanManager bm) {
        for (Annotation annotation : annotations) {
            if (!bm.isNormalScope(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    JmxBroadcaster getBroadcasterFor(Class<?> clazz) {
        return this.wrappers.get(clazz);
    }

    private MBeanServer mBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

