/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;
import org.apache.deltaspike.core.spi.activation.Deactivatable;

@Dependent
@Typed(value={NamedMessageBundleInvocationHandler.class})
public class NamedMessageBundleInvocationHandler
extends MessageBundleInvocationHandler
implements Deactivatable {
    private static final long serialVersionUID = -7089857581799104783L;
    private Class<?> targetType;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int argCount = 0;
        boolean nullValueFound = false;
        String methodName = new RuntimeException().getStackTrace()[1].getMethodName();
        if (args != null) {
            argCount = args.length;
        }
        Class[] paramTypes = new Class[argCount];
        for (int i = 0; i < argCount; ++i) {
            if (args[i] != null) {
                paramTypes[i] = args[i].getClass();
                continue;
            }
            nullValueFound = true;
        }
        Method targetMethod = null;
        if (!nullValueFound) {
            targetMethod = this.targetType.getMethod(methodName, paramTypes);
        } else {
            for (Method currentMethod : this.targetType.getDeclaredMethods()) {
                if (currentMethod.getParameterTypes().length != argCount || !currentMethod.getName().equals(methodName)) continue;
                if (targetMethod != null) {
                    throw new IllegalStateException("Two methods with the same name and parameter-count found. It isn't possible to select the correct one, because one argument is 'null'.");
                }
                targetMethod = currentMethod;
            }
        }
        if (targetMethod == null) {
            throw new IllegalStateException(methodName + " can't be found on " + this.targetType);
        }
        return super.invoke(proxy, targetMethod, args);
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }
}

