/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.spi.config.BaseConfigPropertyProducer;

@ApplicationScoped
public class DefaultConfigPropertyProducer
extends BaseConfigPropertyProducer {
    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public String produceStringConfiguration(InjectionPoint injectionPoint) {
        return this.getStringPropertyValue(injectionPoint);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Class produceClassConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Class.class);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Boolean produceBooleanConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Boolean.class);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Integer produceIntegerConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Integer.class);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Long produceLongConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Long.class);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Float produceFloatConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Float.class);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Double produceDoubleConfiguration(InjectionPoint injectionPoint) {
        return this.getPropertyWithException(injectionPoint, Double.class);
    }

    private <T> T getPropertyWithException(InjectionPoint ip, Class<T> ipCls) {
        try {
            return (T)this.getPropertyValue(ip, ipCls);
        }
        catch (RuntimeException rte) {
            ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(ip, ConfigProperty.class);
            throw new RuntimeException("Error while converting property '" + configProperty.name() + "' happening in bean " + ip.getBean(), rte);
        }
    }
}

