/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.future;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.future.Futureable;
import org.apache.deltaspike.core.impl.future.J8PromiseCompanionTask;
import org.apache.deltaspike.core.impl.future.ThreadPoolManager;
import org.apache.deltaspike.core.impl.util.AnnotatedMethods;
import org.apache.deltaspike.core.spi.future.FutureableStrategy;
import org.apache.deltaspike.core.util.ExceptionUtils;

@Dependent
public class DefaultFutureableStrategy
implements FutureableStrategy {
    private static final Class<?> COMPLETION_STAGE;
    private static final Class<?> COMPLETABLE_FUTURE;
    private static final Method COMPLETABLE_STAGE_TO_FUTURE;
    @Inject
    private ThreadPoolManager manager;
    @Inject
    private BeanManager beanManager;
    private transient ConcurrentMap<Method, ExecutorService> configByMethod = new ConcurrentHashMap<Method, ExecutorService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(final InvocationContext ic) throws Exception {
        Class<?> returnType = ic.getMethod().getReturnType();
        if (!(Future.class.isAssignableFrom(returnType) || COMPLETION_STAGE != null && COMPLETION_STAGE.isAssignableFrom(returnType))) {
            throw new IllegalArgumentException("Return type should be a CompletableStage or Future");
        }
        if (this.configByMethod == null) {
            DefaultFutureableStrategy defaultFutureableStrategy = this;
            synchronized (defaultFutureableStrategy) {
                if (this.configByMethod == null) {
                    this.configByMethod = new ConcurrentHashMap<Method, ExecutorService>();
                }
            }
        }
        Callable<Object> invocation = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object proceed = ic.proceed();
                    Future future = COMPLETION_STAGE == null || !COMPLETION_STAGE.isInstance(proceed) ? (Future)Future.class.cast(proceed) : (Future)Future.class.cast(COMPLETABLE_STAGE_TO_FUTURE.invoke(proceed, new Object[0]));
                    return future.get();
                }
                catch (InvocationTargetException e) {
                    throw ExceptionUtils.throwAsRuntimeException((Throwable)e.getCause());
                }
                catch (Exception e) {
                    throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
        };
        ExecutorService pool = this.getOrCreatePool(ic);
        if (COMPLETABLE_FUTURE == null) {
            return pool.submit(invocation);
        }
        Object completableFuture = COMPLETABLE_FUTURE.newInstance();
        pool.submit(new J8PromiseCompanionTask<Object>(completableFuture, invocation));
        return completableFuture;
    }

    protected ExecutorService getOrCreatePool(InvocationContext ic) {
        Method method = ic.getMethod();
        ExecutorService executorService = (ExecutorService)this.configByMethod.get(method);
        if (executorService == null) {
            AnnotatedType annotatedType = this.beanManager.createAnnotatedType(method.getDeclaringClass());
            AnnotatedMethod<?> annotatedMethod = AnnotatedMethods.findMethod(annotatedType, method);
            Futureable methodConfig = (Futureable)annotatedMethod.getAnnotation(Futureable.class);
            ExecutorService instance = this.manager.find((methodConfig == null ? (Futureable)annotatedType.getAnnotation(Futureable.class) : methodConfig).value());
            this.configByMethod.putIfAbsent(method, instance);
            executorService = instance;
        }
        return executorService;
    }

    static {
        Class<?> completionStageClass = null;
        Class<?> completableFutureClass = null;
        Method completionStageClassToCompletableFuture = null;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            completionStageClass = classLoader.loadClass("java.util.concurrent.CompletionStage");
            completionStageClassToCompletableFuture = completionStageClass.getMethod("toCompletableFuture", new Class[0]);
            completableFutureClass = classLoader.loadClass("java.util.concurrent.CompletableFuture");
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMPLETION_STAGE = completionStageClass;
        COMPLETABLE_FUTURE = completableFutureClass;
        COMPLETABLE_STAGE_TO_FUTURE = completionStageClassToCompletableFuture;
    }
}

