/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.PropertyFileConfig;
import org.apache.deltaspike.core.api.exclude.Exclude;
import org.apache.deltaspike.core.impl.config.EnvironmentPropertyConfigSourceProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigValidator;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ServiceUtils;

public class ConfigurationExtension
implements Extension,
Deactivatable {
    private static final String CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG = "Cannot create ConfigSource for custom property-file config ";
    private static Map<ClassLoader, List<Class<? extends PropertyFileConfig>>> detectedParentPropertyFileConfigs = new ConcurrentHashMap<ClassLoader, List<Class<? extends PropertyFileConfig>>>();
    private boolean isActivated = true;
    private List<Class<? extends PropertyFileConfig>> propertyFileConfigClasses = new ArrayList<Class<? extends PropertyFileConfig>>();

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public void collectUserConfigSources(@Observes ProcessAnnotatedType<? extends PropertyFileConfig> pat) {
        if (!this.isActivated) {
            return;
        }
        Class pcsClass = pat.getAnnotatedType().getJavaClass();
        if (pcsClass.isAnnotation() || pcsClass.isInterface() || pcsClass.isSynthetic() || pcsClass.isArray() || pcsClass.isEnum()) {
            return;
        }
        if (pat.getAnnotatedType().isAnnotationPresent(Exclude.class)) {
            return;
        }
        this.propertyFileConfigClasses.add(pcsClass);
    }

    public void registerUserConfigSources(@Observes AfterDeploymentValidation adv) {
        if (!this.isActivated) {
            return;
        }
        HashSet<Class<? extends PropertyFileConfig>> allPropertyFileConfigClasses = new HashSet<Class<? extends PropertyFileConfig>>(this.propertyFileConfigClasses);
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        this.addParentPropertyFileConfigs(currentClassLoader, allPropertyFileConfigClasses);
        if (!this.propertyFileConfigClasses.isEmpty()) {
            detectedParentPropertyFileConfigs.put(currentClassLoader, this.propertyFileConfigClasses);
        }
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        for (Class clazz : allPropertyFileConfigClasses) {
            configSources.addAll(this.createPropertyConfigSource(clazz));
        }
        ConfigResolver.addConfigSources(configSources);
        this.processConfigurationValidation(adv);
    }

    private void addParentPropertyFileConfigs(ClassLoader currentClassLoader, Set<Class<? extends PropertyFileConfig>> propertyFileConfigClasses) {
        if (currentClassLoader.getParent() == null) {
            return;
        }
        for (Map.Entry<ClassLoader, List<Class<? extends PropertyFileConfig>>> classLoaderListEntry : detectedParentPropertyFileConfigs.entrySet()) {
            if (!currentClassLoader.getParent().equals(classLoaderListEntry.getKey())) continue;
            propertyFileConfigClasses.addAll((Collection<Class<? extends PropertyFileConfig>>)classLoaderListEntry.getValue());
            this.addParentPropertyFileConfigs(classLoaderListEntry.getKey(), propertyFileConfigClasses);
            return;
        }
    }

    public void freeConfigSources(@Observes BeforeShutdown bs) {
        ConfigResolver.freeConfigSources();
        detectedParentPropertyFileConfigs.remove(ClassUtils.getClassLoader(null));
    }

    private List<ConfigSource> createPropertyConfigSource(Class<? extends PropertyFileConfig> propertyFileConfigClass) {
        String fileName = "";
        try {
            PropertyFileConfig propertyFileConfig = propertyFileConfigClass.newInstance();
            fileName = propertyFileConfig.getPropertyFileName();
            EnvironmentPropertyConfigSourceProvider environmentPropertyConfigSourceProvider = new EnvironmentPropertyConfigSourceProvider(fileName, propertyFileConfig.isOptional());
            return environmentPropertyConfigSourceProvider.getConfigSources();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG + propertyFileConfigClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG + propertyFileConfigClass.getName(), e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(propertyFileConfigClass.getName() + " points to an invalid file: '" + fileName + "'", e);
        }
    }

    protected void processConfigurationValidation(AfterDeploymentValidation adv) {
        for (ConfigValidator configValidator : ServiceUtils.loadServiceImplementations(ConfigValidator.class)) {
            Set violations = configValidator.processValidation();
            if (violations == null) continue;
            for (String violation : violations) {
                adv.addDeploymentProblem((Throwable)new IllegalStateException(violation));
            }
        }
    }
}

