/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.future;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;

@ApplicationScoped
public class ThreadPoolManager {
    private final ConcurrentMap<String, ExecutorService> pools = new ConcurrentHashMap<String, ExecutorService>();
    private volatile ExecutorService defaultPool;
    private volatile boolean closed = false;

    @PreDestroy
    private void shutdown() {
        this.closed = true;
        long timeout = CoreBaseConfig.TimeoutCustomization.FUTUREABLE_TERMINATION_TIMEOUT_IN_MILLISECONDS.intValue();
        for (ExecutorService es : this.pools.values()) {
            es.shutdown();
            try {
                es.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (this.defaultPool != null) {
            this.defaultPool.shutdown();
            try {
                this.defaultPool.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        this.pools.clear();
    }

    public ExecutorService find(String name) {
        if (this.closed) {
            throw new IllegalStateException("Container is shutting down");
        }
        ExecutorService pool = (ExecutorService)this.pools.get(name);
        if (pool == null) {
            this.ensureDefaultPool();
            pool = this.defaultPool;
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDefaultPool() {
        if (this.defaultPool == null) {
            ThreadPoolManager threadPoolManager = this;
            synchronized (threadPoolManager) {
                if (this.defaultPool == null) {
                    this.defaultPool = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()));
                }
            }
        }
    }
}

