/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.jmx.JmxBroadcaster;
import org.apache.deltaspike.core.api.jmx.JmxManaged;
import org.apache.deltaspike.core.api.jmx.JmxParameter;
import org.apache.deltaspike.core.api.jmx.MBean;
import org.apache.deltaspike.core.api.jmx.NotificationInfo;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.jmx.AttributeAccessor;
import org.apache.deltaspike.core.util.ParameterUtil;

public class DynamicMBeanWrapper
extends NotificationBroadcasterSupport
implements DynamicMBean,
JmxBroadcaster {
    public static final Logger LOGGER = Logger.getLogger(DynamicMBeanWrapper.class.getName());
    private final MBeanInfo info;
    private final Map<String, AttributeAccessor> fields = new HashMap<String, AttributeAccessor>();
    private final Map<String, Method> operations = new HashMap<String, Method>();
    private final ClassLoader classloader;
    private final Class<?> clazz;
    private final boolean normalScope;
    private final Annotation[] qualifiers;
    private Object instance = null;

    /*
     * WARNING - void declaration
     */
    public DynamicMBeanWrapper(Class<?> annotatedMBean, boolean normalScope, Annotation[] qualifiers) {
        void var10_13;
        JmxManaged annotation;
        NotificationInfo.List notifications;
        this.clazz = annotatedMBean;
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.normalScope = normalScope;
        this.qualifiers = qualifiers;
        ArrayList<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operationInfos = new ArrayList<MBeanOperationInfo>();
        ArrayList<MBeanNotificationInfo> notificationInfos = new ArrayList<MBeanNotificationInfo>();
        String description = this.getDescription(annotatedMBean.getAnnotation(MBean.class).description(), annotatedMBean.getName());
        NotificationInfo notification = annotatedMBean.getAnnotation(NotificationInfo.class);
        if (notification != null) {
            notificationInfos.add(this.getNotificationInfo(notification, annotatedMBean.getName()));
        }
        if ((notifications = annotatedMBean.getAnnotation(NotificationInfo.List.class)) != null) {
            for (NotificationInfo notificationInfo : notifications.value()) {
                notificationInfos.add(this.getNotificationInfo(notificationInfo, annotatedMBean.getName()));
            }
        }
        for (Method method : annotatedMBean.getMethods()) {
            int modifiers = method.getModifiers();
            annotation = method.getAnnotation(JmxManaged.class);
            if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers) || annotation == null) continue;
            this.operations.put(method.getName(), method);
            String operationDescr = this.getDescription(annotation.description(), method.getName());
            Annotation[][] parametersAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[parameterTypes.length];
            for (int i = 0; i < parametersAnnotations.length; ++i) {
                String parameterDescription = null;
                String parameterName = "p" + (i + 1);
                String java8ParameterName = ParameterUtil.getName((Method)method, (int)i);
                if (java8ParameterName != null) {
                    parameterName = java8ParameterName;
                }
                for (int j = 0; j < parametersAnnotations[i].length; ++j) {
                    if (!(parametersAnnotations[i][j] instanceof JmxParameter)) continue;
                    JmxParameter jmxParameter = (JmxParameter)parametersAnnotations[i][j];
                    if (!"".equals(jmxParameter.name())) {
                        parameterName = jmxParameter.name();
                    }
                    if ("".equals(jmxParameter.description())) continue;
                    parameterDescription = jmxParameter.description();
                }
                parameterInfos[i] = new MBeanParameterInfo(parameterName, parameterTypes[i].getName(), parameterDescription);
            }
            operationInfos.add(new MBeanOperationInfo(method.getName(), operationDescr, parameterInfos, method.getReturnType().getName(), 3));
        }
        Class<?> clazz = annotatedMBean;
        while (!Object.class.equals((Object)var10_13) && var10_13 != null) {
            void var13_22;
            Field[] fieldArray = var10_13.getDeclaredFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var13_22 < n) {
                Field field = fieldArray[var13_22];
                annotation = field.getAnnotation(JmxManaged.class);
                if (annotation != null) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    String fieldDescription = this.getDescription(annotation.description(), fieldName);
                    Class<?> type = field.getType();
                    String methodName = fieldName.length() > 1 ? Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1) : Character.toString(Character.toUpperCase(fieldName.charAt(0)));
                    Method setter = null;
                    Method getter = null;
                    try {
                        getter = var10_13.getMethod("get" + methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            getter = var10_13.getMethod("is" + methodName, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    try {
                        setter = var10_13.getMethod("set" + methodName, field.getType());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    attributeInfos.add(new MBeanAttributeInfo(fieldName, type.getName(), fieldDescription, getter != null, setter != null, false));
                    this.fields.put(fieldName, new AttributeAccessor(getter, setter));
                }
                ++var13_22;
            }
            Class clazz2 = var10_13.getSuperclass();
        }
        this.info = new MBeanInfo(annotatedMBean.getName(), description, attributeInfos.toArray(new MBeanAttributeInfo[attributeInfos.size()]), null, operationInfos.toArray(new MBeanOperationInfo[operationInfos.size()]), notificationInfos.toArray(new MBeanNotificationInfo[notificationInfos.size()]));
    }

    private MBeanNotificationInfo getNotificationInfo(NotificationInfo notificationInfo, String sourceInfo) {
        return new MBeanNotificationInfo(notificationInfo.types(), notificationInfo.notificationClass().getName(), this.getDescription(notificationInfo.description(), sourceInfo), new ImmutableDescriptor(notificationInfo.descriptorFields()));
    }

    private String getDescription(String description, String defaultDescription) {
        if (description.isEmpty()) {
            return defaultDescription;
        }
        String descriptionValue = description.trim();
        if (descriptionValue.startsWith("{") && descriptionValue.endsWith("}")) {
            return ConfigResolver.getPropertyValue((String)descriptionValue.substring(1, descriptionValue.length() - 1), (String)defaultDescription);
        }
        return description;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.fields.containsKey(attribute)) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Object object = this.fields.get(attribute).get(this.instance());
                return object;
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "can't get " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "can't get " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "can't get " + attribute + " value", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        throw new AttributeNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.fields.containsKey(attribute.getName())) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                this.fields.get(attribute.getName()).set(this.instance(), attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "can't set " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "can't set " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "can't set " + attribute + " value", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        } else {
            throw new AttributeNotFoundException();
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String n : attributes) {
            try {
                list.add(new Attribute(n, this.getAttribute(n)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (Object o : attributes) {
            Attribute attr = (Attribute)o;
            try {
                this.setAttribute(attr);
                list.add(attr);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.operations.containsKey(actionName)) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Object object = this.operations.get(actionName).invoke(this.instance(), params);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof MBeanException) {
                    throw (MBeanException)cause;
                }
                throw new MBeanException((Exception)cause, actionName + " failed with exception");
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e, actionName + " could not be invoked");
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e, actionName + " could not be invoked");
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        throw new ReflectionException(new NoSuchMethodException(actionName + " doesn't exist"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object instance() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classloader);
        try {
            if (this.instance != null) {
                Object object = this.instance;
                return object;
            }
            if (this.normalScope) {
                this.instance = BeanProvider.getContextualReference(this.clazz, (Annotation[])this.qualifiers);
            } else {
                BeanManager bm = BeanManagerProvider.getInstance().getBeanManager();
                Set beans = bm.getBeans(this.clazz, this.qualifiers);
                if (beans == null || beans.isEmpty()) {
                    throw new IllegalStateException("Could not find beans for Type=" + this.clazz + " and qualifiers:" + Arrays.toString(this.qualifiers));
                }
                Bean resolvedBean = bm.resolve(beans);
                CreationalContext creationalContext = bm.createCreationalContext((Contextual)resolvedBean);
                this.instance = bm.getReference(resolvedBean, this.clazz, creationalContext);
                creationalContext.release();
            }
            Object object = this.instance;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void send(Notification notification) {
        this.sendNotification(notification);
    }
}

