/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.monitoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.apache.deltaspike.core.api.monitoring.MonitorResultEvent;

@ApplicationScoped
public class InvocationResultLogger {
    private static final Logger logger = Logger.getLogger(InvocationResultLogger.class.getName());
    private static final int DEFAULT_MAX_LOG_LINES = 8;
    private static final String PROPERTY_MAX_LOG_LINES = "MAX_LOG_LINES";
    private int maxLogLines = 9;

    @PostConstruct
    private void init() {
        String maxLogLinesProp = System.getProperty(PROPERTY_MAX_LOG_LINES);
        if (maxLogLinesProp != null) {
            this.maxLogLines = Integer.parseInt(maxLogLinesProp) + 1;
        }
        logger.info("Using MAX_LOG_LINE=" + this.maxLogLines);
    }

    public void logMonitorResultEvents(@Observes MonitorResultEvent mre) {
        ResultEntry re;
        int i;
        List<ResultEntry> methodInvocations = this.createMethodResultEntries(mre.getMethodInvocations(), mre.getMethodDurations());
        List<ResultEntry> classInvocations = this.createClassResultEntries(mre.getClassInvocations());
        StringBuilder sb = new StringBuilder();
        sb.append("Top Class Invocations:\n");
        for (i = 1; i < this.maxLogLines && i <= classInvocations.size(); ++i) {
            re = classInvocations.get(classInvocations.size() - i);
            sb.append("  count: ").append(re.getCount()).append("\t").append(re.getToken()).append("\n");
        }
        logger.info(sb.toString());
        sb = new StringBuilder();
        sb.append("Top Method Invocations:\n");
        for (i = 1; i < this.maxLogLines && i <= methodInvocations.size(); ++i) {
            re = methodInvocations.get(methodInvocations.size() - i);
            sb.append("  dur[ms]: ").append((float)re.getDuration() / 1000000.0f).append("\tcount: ").append(re.getCount()).append("\t").append(re.getToken()).append("\n");
        }
        logger.info(sb.toString());
    }

    private List<ResultEntry> createMethodResultEntries(Map<String, AtomicInteger> invocations, Map<String, AtomicLong> durations) {
        ArrayList<ResultEntry> resultEntries = new ArrayList<ResultEntry>(invocations.size());
        for (Map.Entry<String, AtomicInteger> entry : invocations.entrySet()) {
            long dur = durations.get(entry.getKey()).longValue();
            resultEntries.add(new ResultEntry(entry.getValue().intValue(), entry.getKey(), dur));
        }
        Collections.sort(resultEntries);
        return resultEntries;
    }

    private List<ResultEntry> createClassResultEntries(Map<String, AtomicInteger> invocations) {
        ArrayList<ResultEntry> resultEntries = new ArrayList<ResultEntry>(invocations.size());
        for (Map.Entry<String, AtomicInteger> entry : invocations.entrySet()) {
            resultEntries.add(new ResultEntry(entry.getValue().intValue(), entry.getKey(), 0L));
        }
        Collections.sort(resultEntries);
        return resultEntries;
    }

    private static class ResultEntry
    implements Comparable<ResultEntry> {
        private Integer count;
        private String token;
        private long duration;

        private ResultEntry(Integer count, String token, long duration) {
            this.count = count;
            this.token = token;
            this.duration = duration;
        }

        public Integer getCount() {
            return this.count;
        }

        public String getToken() {
            return this.token;
        }

        public long getDuration() {
            return this.duration;
        }

        @Override
        public int compareTo(ResultEntry o) {
            if (this.duration == 0L && o.duration == 0L) {
                return this.count.compareTo(o.count);
            }
            return this.duration < o.duration ? -1 : (this.duration == o.duration ? 0 : 1);
        }
    }
}

