/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.RevisionName;
import org.apache.directory.mavibot.btree.RevisionOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceReclaimer {
    private RecordManager rm;
    private static String COPIED_PAGE_MAP_DATA_FILE = "cpm.db";
    protected static final Logger LOG = LoggerFactory.getLogger(SpaceReclaimer.class);

    public SpaceReclaimer(RecordManager rm) {
        this.rm = rm;
    }

    void storeCopiedPageMap(File dir) {
        if (this.rm.copiedPageMap.isEmpty()) {
            LOG.debug("Copied page map is empty, nothing to store on disk.");
            return;
        }
        File file = new File(dir, COPIED_PAGE_MAP_DATA_FILE);
        try {
            LOG.debug("Storing {} RevisionNames of Copied page map", (Object)this.rm.copiedPageMap.size());
            FileOutputStream fileOut = new FileOutputStream(file);
            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(this.rm.copiedPageMap);
            objOut.close();
            LOG.debug("Successfully stored copied page map in {}", (Object)file.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.warn("Failed to store the copied page map in {}", (Object)file.getAbsolutePath());
            LOG.warn("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentHashMap<RevisionName, long[]> readCopiedPageMap(File dir) {
        ConcurrentHashMap map;
        block6: {
            map = new ConcurrentHashMap();
            File file = new File(dir, COPIED_PAGE_MAP_DATA_FILE);
            if (!file.exists()) {
                LOG.debug("Copied page map store {} doesn't exist, returning empty map", (Object)file.getAbsolutePath());
                return map;
            }
            try {
                LOG.debug("Reading Copied page map data stored in {}", (Object)file.getAbsolutePath());
                FileInputStream fileIn = new FileInputStream(file);
                ObjectInputStream objIn = new ObjectInputStream(fileIn);
                map = (ConcurrentHashMap)objIn.readObject();
                objIn.close();
                LOG.debug("Successfully read copied page map containing {} RevisionNames", (Object)map.size());
            }
            catch (Exception e) {
                LOG.warn("Failed to read the copied page map from {}", (Object)file.getAbsolutePath());
                LOG.warn("", (Throwable)e);
            }
            finally {
                boolean deleted = file.delete();
                if (deleted) break block6;
                String warn = "Failed to delete the copied page map store " + file.getAbsolutePath() + " Make sure the approapriate permissions are given to delete this file by mavibot process.";
                LOG.warn(warn);
                throw new RuntimeException(warn);
            }
        }
        return map;
    }

    void reclaim() {
        try {
            Set<String> managed = this.rm.getManagedTrees();
            for (String name : managed) {
                RevisionOffset ro;
                long rv;
                PersistedBTree tree = (PersistedBTree)this.rm.getManagedTree(name);
                TreeSet<Long> inUseRevisions = new TreeSet<Long>();
                if (tree != null) {
                    Iterator txnItr = tree.getReadTransactions().iterator();
                    while (txnItr.hasNext()) {
                        inUseRevisions.add(txnItr.next().getRevision());
                    }
                }
                List<RevisionOffset> copiedRevisions = this.getRevisions(name);
                Iterator<RevisionOffset> i$ = copiedRevisions.iterator();
                while (i$.hasNext() && !inUseRevisions.contains(rv = (ro = i$.next()).getRevision())) {
                    long[] offsets = ro.getOffsets();
                    this.rm.free(offsets);
                    RevisionName key = new RevisionName(rv, name);
                    this.rm.copiedPageMap.remove(key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<RevisionOffset> getRevisions(String name) throws Exception {
        long nbElems = this.rm.copiedPageMap.size();
        if (nbElems == 0L) {
            return Collections.EMPTY_LIST;
        }
        Iterator<Map.Entry<RevisionName, long[]>> cursor = this.rm.copiedPageMap.entrySet().iterator();
        ArrayList<RevisionOffset> lst = new ArrayList<RevisionOffset>();
        while (cursor.hasNext()) {
            Map.Entry<RevisionName, long[]> t = cursor.next();
            RevisionName rn = t.getKey();
            if (!name.equals(rn.getName())) continue;
            lst.add(new RevisionOffset(rn.getRevision(), t.getValue()));
        }
        return lst;
    }
}

