/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;

public class DefaultIoFilterChainBuilder
implements IoFilterChainBuilder,
Cloneable {
    private List entries = new ArrayList();
    private final Map entriesByName = new HashMap();

    public synchronized IoFilterChain.Entry getEntry(String name) {
        return (IoFilterChain.Entry)this.entriesByName.get(name);
    }

    public synchronized IoFilter get(String name) {
        IoFilterChain.Entry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        return e.getFilter();
    }

    public List getAll() {
        return new ArrayList(this.entries);
    }

    public List getAllReversed() {
        List result = this.getAll();
        Collections.reverse(result);
        return result;
    }

    public boolean contains(String name) {
        return this.getEntry(name) != null;
    }

    public boolean contains(IoFilter filter) {
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            if (e.getFilter() != filter) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class filterType) {
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            if (!filterType.isAssignableFrom(e.getFilter().getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addFirst(String name, IoFilter filter) {
        this.register(0, new EntryImpl(name, filter));
    }

    public synchronized void addLast(String name, IoFilter filter) {
        this.register(this.entries.size(), new EntryImpl(name, filter));
    }

    public synchronized void addBefore(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ListIterator i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = (IoFilterChain.Entry)i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.previousIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized void addAfter(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ArrayList entries = new ArrayList(this.entries);
        ListIterator i = entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = (IoFilterChain.Entry)i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.nextIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized IoFilter remove(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ListIterator i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            if (!e.getName().equals(name)) continue;
            this.deregister(i.previousIndex(), e);
            return e.getFilter();
        }
        throw new IllegalArgumentException("Unknown filter name: " + name);
    }

    public synchronized void clear() throws Exception {
        this.entries = new ArrayList();
        this.entriesByName.clear();
    }

    public void buildFilterChain(IoFilterChain chain) throws Exception {
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            chain.addLast(e.getName(), e.getFilter());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        boolean empty = true;
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            if (!empty) {
                buf.append(", ");
            } else {
                empty = false;
            }
            buf.append('(');
            buf.append(e.getName());
            buf.append(':');
            buf.append(e.getFilter());
            buf.append(')');
        }
        if (empty) {
            buf.append("empty");
        }
        buf.append(" }");
        return buf.toString();
    }

    public Object clone() {
        DefaultIoFilterChainBuilder ret = new DefaultIoFilterChainBuilder();
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = (IoFilterChain.Entry)i.next();
            ret.addLast(e.getName(), e.getFilter());
        }
        return ret;
    }

    private void checkBaseName(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName");
        }
        if (!this.entriesByName.containsKey(baseName)) {
            throw new IllegalArgumentException("Unknown filter name: " + baseName);
        }
    }

    private void register(int index, IoFilterChain.Entry e) {
        if (this.entriesByName.containsKey(e.getName())) {
            throw new IllegalArgumentException("Other filter is using the same name: " + e.getName());
        }
        ArrayList<IoFilterChain.Entry> newEntries = new ArrayList<IoFilterChain.Entry>(this.entries);
        newEntries.add(index, e);
        this.entries = newEntries;
        this.entriesByName.put(e.getName(), e);
    }

    private void deregister(int index, IoFilterChain.Entry e) {
        ArrayList newEntries = new ArrayList(this.entries);
        newEntries.remove(index);
        this.entries = newEntries;
        this.entriesByName.remove(e.getName());
    }

    private static class EntryImpl
    implements IoFilterChain.Entry {
        private final String name;
        private final IoFilter filter;

        private EntryImpl(String name, IoFilter filter) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }

        public IoFilter.NextFilter getNextFilter() {
            throw new IllegalStateException();
        }
    }
}

