/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

public class IoFuture {
    private final Object lock;
    private Object result;
    private Callback callback;
    private boolean ready;

    public IoFuture() {
        this.lock = this;
    }

    public IoFuture(Object lock) {
        if (lock == null) {
            throw new NullPointerException("lock");
        }
        this.lock = lock;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(long timeoutInMillis) {
        long startTime = timeoutInMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutInMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (waitTime <= 0L) {
                return this.ready;
            }
            do {
                try {
                    this.lock.wait(waitTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.ready) continue;
                return true;
            } while ((waitTime = timeoutInMillis - (System.currentTimeMillis() - startTime)) > 0L);
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.result = newValue;
            this.ready = true;
            this.lock.notifyAll();
            if (this.callback != null) {
                this.invokeCallback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callback getCallback() {
        Object object = this.lock;
        synchronized (object) {
            return this.callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        Object object = this.lock;
        synchronized (object) {
            this.callback = callback;
            if (this.ready) {
                this.invokeCallback();
            }
        }
    }

    private void invokeCallback() {
        this.callback.operationComplete(this);
    }

    public static interface Callback {
        public void operationComplete(IoFuture var1);
    }
}

