/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.ThreadPoolFilter;

public class PooledThreadModel
implements ThreadModel {
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 16;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60000;
    private static int id = 1;
    private final ThreadPoolFilter pool = new ThreadPoolFilter();

    public PooledThreadModel() {
        this("AnonymousIoService-" + id++, 16);
    }

    public PooledThreadModel(int maxThreads) {
        this("AnonymousIoService-" + id++, maxThreads);
    }

    public PooledThreadModel(String threadNamePrefix) {
        this(threadNamePrefix, 16);
    }

    public PooledThreadModel(String threadNamePrefix, int maxThreads) {
        this.setMaximumPoolSize(maxThreads);
        this.setThreadNamePrefix(threadNamePrefix);
    }

    public String getThreadNamePrefix() {
        return this.pool.getThreadNamePrefix();
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.pool.setThreadNamePrefix(threadNamePrefix);
    }

    public int getMaximumPoolSize() {
        return this.pool.getMaximumPoolSize();
    }

    public int getKeepAliveTime() {
        return this.pool.getKeepAliveTime();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.pool.setMaximumPoolSize(maximumPoolSize);
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.pool.setKeepAliveTime(keepAliveTime);
    }

    public void buildFilterChain(IoFilterChain chain) throws Exception {
        chain.addFirst(PooledThreadModel.class.getName(), this.pool);
    }
}

