/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;

public class SimpleByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;

    public ByteBuffer allocate(int capacity, boolean direct) {
        java.nio.ByteBuffer nioBuffer = direct ? java.nio.ByteBuffer.allocateDirect(capacity) : java.nio.ByteBuffer.allocate(capacity);
        return new SimpleByteBuffer(nioBuffer);
    }

    public ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        return new SimpleByteBuffer(nioBuffer);
    }

    public void dispose() {
    }

    private static class SimpleByteBuffer
    extends ByteBuffer {
        private java.nio.ByteBuffer buf;
        private int refCount = 1;
        private boolean autoExpand;

        protected SimpleByteBuffer(java.nio.ByteBuffer buf) {
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
            this.autoExpand = false;
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            SimpleByteBuffer simpleByteBuffer = this;
            synchronized (simpleByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isDirect() {
            return this.buf.isDirect();
        }

        public boolean isReadOnly() {
            return this.buf.isReadOnly();
        }

        public boolean isAutoExpand() {
            return this.autoExpand;
        }

        public ByteBuffer setAutoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public boolean isPooled() {
            return false;
        }

        public void setPooled(boolean pooled) {
        }

        public int capacity() {
            return this.buf.capacity();
        }

        public int position() {
            return this.buf.position();
        }

        public ByteBuffer position(int newPosition) {
            this.autoExpand(newPosition, 0);
            this.buf.position(newPosition);
            return this;
        }

        public int limit() {
            return this.buf.limit();
        }

        public ByteBuffer limit(int newLimit) {
            this.autoExpand(newLimit, 0);
            this.buf.limit(newLimit);
            return this;
        }

        public ByteBuffer mark() {
            this.buf.mark();
            return this;
        }

        public ByteBuffer reset() {
            this.buf.reset();
            return this;
        }

        public ByteBuffer clear() {
            this.buf.clear();
            return this;
        }

        public ByteBuffer flip() {
            this.buf.flip();
            return this;
        }

        public ByteBuffer rewind() {
            this.buf.rewind();
            return this;
        }

        public int remaining() {
            return this.buf.remaining();
        }

        public byte get() {
            return this.buf.get();
        }

        public ByteBuffer put(byte b) {
            this.autoExpand(1);
            this.buf.put(b);
            return this;
        }

        public byte get(int index) {
            return this.buf.get(index);
        }

        public ByteBuffer put(int index, byte b) {
            this.autoExpand(index, 1);
            this.buf.put(index, b);
            return this;
        }

        public ByteBuffer get(byte[] dst, int offset, int length) {
            this.buf.get(dst, offset, length);
            return this;
        }

        public ByteBuffer put(java.nio.ByteBuffer src) {
            this.autoExpand(src.remaining());
            this.buf.put(src);
            return this;
        }

        public ByteBuffer put(byte[] src, int offset, int length) {
            this.autoExpand(length);
            this.buf.put(src, offset, length);
            return this;
        }

        public ByteBuffer compact() {
            this.buf.compact();
            return this;
        }

        public int compareTo(ByteBuffer that) {
            return this.buf.compareTo(that.buf());
        }

        public ByteOrder order() {
            return this.buf.order();
        }

        public ByteBuffer order(ByteOrder bo) {
            this.buf.order(bo);
            return this;
        }

        public char getChar() {
            return this.buf.getChar();
        }

        public ByteBuffer putChar(char value) {
            this.autoExpand(2);
            this.buf.putChar(value);
            return this;
        }

        public char getChar(int index) {
            return this.buf.getChar(index);
        }

        public ByteBuffer putChar(int index, char value) {
            this.autoExpand(index, 2);
            this.buf.putChar(index, value);
            return this;
        }

        public CharBuffer asCharBuffer() {
            return this.buf.asCharBuffer();
        }

        public short getShort() {
            return this.buf.getShort();
        }

        public ByteBuffer putShort(short value) {
            this.autoExpand(2);
            this.buf.putShort(value);
            return this;
        }

        public short getShort(int index) {
            return this.buf.getShort(index);
        }

        public ByteBuffer putShort(int index, short value) {
            this.autoExpand(index, 2);
            this.buf.putShort(index, value);
            return this;
        }

        public ShortBuffer asShortBuffer() {
            return this.buf.asShortBuffer();
        }

        public int getInt() {
            return this.buf.getInt();
        }

        public ByteBuffer putInt(int value) {
            this.autoExpand(4);
            this.buf.putInt(value);
            return this;
        }

        public int getInt(int index) {
            return this.buf.getInt(index);
        }

        public ByteBuffer putInt(int index, int value) {
            this.autoExpand(index, 4);
            this.buf.putInt(index, value);
            return this;
        }

        public IntBuffer asIntBuffer() {
            return this.buf.asIntBuffer();
        }

        public long getLong() {
            return this.buf.getLong();
        }

        public ByteBuffer putLong(long value) {
            this.autoExpand(8);
            this.buf.putLong(value);
            return this;
        }

        public long getLong(int index) {
            return this.buf.getLong(index);
        }

        public ByteBuffer putLong(int index, long value) {
            this.autoExpand(index, 8);
            this.buf.putLong(index, value);
            return this;
        }

        public LongBuffer asLongBuffer() {
            return this.buf.asLongBuffer();
        }

        public float getFloat() {
            return this.buf.getFloat();
        }

        public ByteBuffer putFloat(float value) {
            this.autoExpand(4);
            this.buf.putFloat(value);
            return this;
        }

        public float getFloat(int index) {
            return this.buf.getFloat(index);
        }

        public ByteBuffer putFloat(int index, float value) {
            this.autoExpand(index, 4);
            this.buf.putFloat(index, value);
            return this;
        }

        public FloatBuffer asFloatBuffer() {
            return this.buf.asFloatBuffer();
        }

        public double getDouble() {
            return this.buf.getDouble();
        }

        public ByteBuffer putDouble(double value) {
            this.autoExpand(8);
            this.buf.putDouble(value);
            return this;
        }

        public double getDouble(int index) {
            return this.buf.getDouble(index);
        }

        public ByteBuffer putDouble(int index, double value) {
            this.autoExpand(index, 8);
            this.buf.putDouble(index, value);
            return this;
        }

        public DoubleBuffer asDoubleBuffer() {
            return this.buf.asDoubleBuffer();
        }

        public ByteBuffer expand(int expectedRemaining) {
            int limit;
            int pos;
            int end;
            if (this.autoExpand && (end = (pos = this.buf.position()) + expectedRemaining) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
            return this;
        }

        public ByteBuffer expand(int pos, int expectedRemaining) {
            int limit;
            int end;
            if (this.autoExpand && (end = pos + expectedRemaining) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
            return this;
        }

        private void ensureCapacity(int requestedCapacity) {
            int newCapacity;
            if (requestedCapacity <= this.buf.capacity()) {
                return;
            }
            for (newCapacity = 1; newCapacity < requestedCapacity; newCapacity <<= 1) {
            }
            java.nio.ByteBuffer oldBuf = this.buf;
            java.nio.ByteBuffer newBuf = this.isDirect() ? java.nio.ByteBuffer.allocateDirect(newCapacity) : java.nio.ByteBuffer.allocate(newCapacity);
            newBuf.clear();
            newBuf.order(oldBuf.order());
            int pos = oldBuf.position();
            int limit = oldBuf.limit();
            oldBuf.clear();
            newBuf.put(oldBuf);
            newBuf.position(0);
            newBuf.limit(limit);
            newBuf.position(pos);
            this.buf = newBuf;
        }

        public ByteBuffer duplicate() {
            return new SimpleByteBuffer(this.buf.duplicate());
        }

        public ByteBuffer slice() {
            return new SimpleByteBuffer(this.buf.slice());
        }

        public ByteBuffer asReadOnlyBuffer() {
            return new SimpleByteBuffer(this.buf.asReadOnlyBuffer());
        }
    }
}

