/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.util.Queue;

public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue bufferQueue = new Queue();

    public Queue getBufferQueue() {
        return this.bufferQueue;
    }

    public synchronized void write(ByteBuffer buf) {
        this.bufferQueue.push(buf);
    }

    public synchronized void mergeAll() {
        ByteBuffer buf;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            sum += ((ByteBuffer)this.bufferQueue.get(i)).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((buf = (ByteBuffer)this.bufferQueue.pop()) != null) {
            newBuf.put(buf);
            buf.release();
        }
        newBuf.flip();
        this.bufferQueue.push(newBuf);
    }

    public synchronized WriteFuture flush() {
        ByteBuffer buf;
        Queue bufferQueue = this.bufferQueue;
        WriteFuture future = null;
        if (bufferQueue.isEmpty()) {
            return null;
        }
        while ((buf = (ByteBuffer)bufferQueue.pop()) != null) {
            if (!buf.hasRemaining()) continue;
            future = this.doFlush(buf);
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

