/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketFilterChain;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.Queue;

public class SocketConnector
extends BaseIoConnector {
    private static volatile int nextId = 0;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private final IoServiceConfig defaultConfig = new SocketConnectorConfig();
    private final Queue connectQueue = new Queue();
    private final Set managedSessions = Collections.synchronizedSet(new HashSet());
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;
    private long workerTimeout = 60000L;

    public SocketConnector() {
        this(1);
    }

    public SocketConnector(int processorCount) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketConnectorIoProcessor-" + this.id + "." + i);
        }
    }

    public long getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(long workerTimeout) {
        if (workerTimeout < 0L) {
            throw new IllegalArgumentException("Must be > 0");
        }
        this.workerTimeout = workerTimeout;
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        SocketChannel ch = null;
        boolean success = false;
        try {
            ch = SocketChannel.open();
            ch.socket().setReuseAddress(true);
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.configureBlocking(false);
            if (ch.connect(address)) {
                SocketSessionImpl session = this.newSession(ch, handler, config);
                success = true;
                ConnectFuture future = new ConnectFuture();
                future.setSession(session);
                ConnectFuture connectFuture = future;
                return connectFuture;
            }
            success = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = ConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!success && ch != null) {
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        ConnectionRequest request = new ConnectionRequest(ch, handler, config);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return ConnectFuture.newFailedFuture(e);
            }
        }
        object = this.connectQueue;
        synchronized (object) {
            this.connectQueue.push(request);
        }
        this.selector.wakeup();
        return request;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)this.connectQueue.pop();
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(this.selector, 8, req);
            }
            catch (IOException e) {
                req.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)key.attachment();
            boolean success = false;
            try {
                ch.finishConnect();
                SocketSessionImpl session = this.newSession(ch, entry.handler, entry.config);
                entry.setSession(session);
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                key.cancel();
                if (success) continue;
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        keys.clear();
    }

    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ConnectionRequest entry;
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)key.attachment()).deadline) continue;
            entry.setException(new ConnectException());
            key.cancel();
        }
    }

    private SocketSessionImpl newSession(SocketChannel ch, IoHandler handler, IoServiceConfig config) throws IOException {
        SocketSessionImpl session = new SocketSessionImpl(this, this.nextProcessor(), this.managedSessions, config.getSessionConfig(), ch, handler, ch.socket().getRemoteSocketAddress());
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getThreadModel().buildFilterChain(session.getFilterChain());
            ((SocketFilterChain)session.getFilterChain()).sessionCreated(session);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Failed to create a session.").initCause(e);
        }
        session.getManagedSessions().add(session);
        session.getIoProcessor().addNew(session);
        return session;
    }

    private SocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    private class ConnectionRequest
    extends ConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private ConnectionRequest(SocketChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            long timeout = config instanceof IoConnectorConfig ? ((IoConnectorConfig)config).getConnectTimeoutMillis() : ((IoConnectorConfig)SocketConnector.this.getDefaultConfig()).getConnectTimeoutMillis();
            this.deadline = System.currentTimeMillis() + timeout;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    extends Thread {
        private long lastActive;

        Worker() {
            super(SocketConnector.this.threadName);
            this.lastActive = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: while (true) {
                try {
                    while (true) {
                        int nKeys = SocketConnector.this.selector.select(1000L);
                        SocketConnector.this.registerNew();
                        if (nKeys > 0) {
                            SocketConnector.this.processSessions(SocketConnector.this.selector.selectedKeys());
                        }
                        SocketConnector.this.processTimedOutSessions(SocketConnector.this.selector.keys());
                        if (SocketConnector.this.selector.keys().isEmpty()) {
                            if (System.currentTimeMillis() - this.lastActive <= SocketConnector.this.workerTimeout) continue;
                            Object object = SocketConnector.this.lock;
                            synchronized (object) {
                                if (SocketConnector.this.selector.keys().isEmpty() && SocketConnector.this.connectQueue.isEmpty()) {
                                    SocketConnector.this.worker = null;
                                    try {
                                        SocketConnector.this.selector.close();
                                    }
                                    catch (IOException e) {
                                        ExceptionMonitor.getInstance().exceptionCaught(e);
                                    }
                                    finally {
                                        SocketConnector.this.selector = null;
                                    }
                                    break block12;
                                }
                                continue block12;
                            }
                        }
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

