/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.Queue;

public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static volatile int nextId = 0;
    private final IoConnector wrapper;
    private final int id = nextId++;
    private Selector selector;
    private final DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker;

    public DatagramConnectorDelegate(IoConnector wrapper) {
        this.wrapper = wrapper;
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        DatagramChannel ch = null;
        boolean initialized = false;
        try {
            ch = DatagramChannel.open();
            DatagramSessionConfig cfg = config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)config.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
            ch.socket().setReuseAddress(cfg.isReuseAddress());
            ch.socket().setBroadcast(cfg.isBroadcast());
            ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
            ch.socket().setSendBufferSize(cfg.getSendBufferSize());
            if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                ch.socket().setTrafficClass(cfg.getTrafficClass());
            }
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.connect(address);
            ch.configureBlocking(false);
            initialized = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = ConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!initialized && ch != null) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        RegistrationRequest request = new RegistrationRequest(ch, handler, config);
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return ConnectFuture.newFailedFuture(e);
            }
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
        }
        this.selector.wakeup();
        return request;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(DatagramSessionImpl session) {
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                return;
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(session);
            }
        }
        this.selector.wakeup();
    }

    public void flushSession(DatagramSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSessionImpl session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    public void updateTrafficMask(DatagramSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(DatagramSessionImpl session) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue writeRequestQueue;
            DatagramSessionImpl session;
            Queue queue = this.trafficControllingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.trafficControllingSessions.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            Queue queue2 = writeRequestQueue = session.getWriteRequestQueue();
            synchronized (queue2) {
                if (!writeRequestQueue.isEmpty()) {
                    ops |= 4;
                }
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramSessionImpl session = (DatagramSessionImpl)key.attachment();
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.readSession(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl session) {
        ByteBuffer readBuf = ByteBuffer.allocate(session.getReadBufferSize());
        try {
            int readBytes = session.getChannel().read(readBuf.buf());
            if (readBytes > 0) {
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(readBytes);
                ((DatagramFilterChain)session.getFilterChain()).messageReceived(session, newBuf);
            }
        }
        catch (IOException e) {
            ((DatagramFilterChain)session.getFilterChain()).exceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (session == null) break;
            try {
                this.flush(session);
            }
            catch (IOException e) {
                ((DatagramFilterChain)session.getFilterChain()).exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSessionImpl session) throws IOException {
        DatagramChannel ch = session.getChannel();
        Queue writeRequestQueue = session.getWriteRequestQueue();
        while (true) {
            IoFilter.WriteRequest req;
            Queue queue = writeRequestQueue;
            synchronized (queue) {
                req = (IoFilter.WriteRequest)writeRequestQueue.first();
            }
            if (req == null) break;
            ByteBuffer buf = (ByteBuffer)req.getMessage();
            if (buf.remaining() == 0) {
                Queue queue2 = writeRequestQueue;
                synchronized (queue2) {
                    writeRequestQueue.pop();
                }
                session.increaseWrittenWriteRequests();
                buf.reset();
                ((DatagramFilterChain)session.getFilterChain()).messageSent(session, req);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            int writtenBytes = ch.write(buf.buf());
            if (writtenBytes == 0) {
                key.interestOps(key.interestOps() | 4);
                continue;
            }
            if (writtenBytes <= 0) continue;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            Queue queue3 = writeRequestQueue;
            synchronized (queue3) {
                writeRequestQueue.pop();
            }
            session.increaseWrittenBytes(writtenBytes);
            session.increaseWrittenWriteRequests();
            buf.reset();
            ((DatagramFilterChain)session.getFilterChain()).messageSent(session, req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramSessionImpl session = new DatagramSessionImpl(this.wrapper, this, req.config.getSessionConfig(), req.channel, req.handler, req.channel.socket().getRemoteSocketAddress());
            boolean success = false;
            try {
                this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                req.config.getThreadModel().buildFilterChain(session.getFilterChain());
                ((DatagramFilterChain)session.getFilterChain()).sessionCreated(session);
                SelectionKey key = req.channel.register(this.selector, 1, session);
                session.setSelectionKey(key);
                req.setSession(session);
                success = true;
                continue;
            }
            catch (Throwable t) {
                req.setException(t);
                continue;
            }
            finally {
                if (success) continue;
                try {
                    req.channel.disconnect();
                    req.channel.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.cancelQueue.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            DatagramChannel ch = (DatagramChannel)key.channel();
            try {
                ch.disconnect();
                ch.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            session.getCloseFuture().setClosed();
            key.cancel();
            this.selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends ConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("DatagramConnector-" + DatagramConnectorDelegate.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = DatagramConnectorDelegate.this.selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(DatagramConnectorDelegate.this.selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!DatagramConnectorDelegate.this.selector.keys().isEmpty());
                    DatagramConnectorDelegate datagramConnectorDelegate = DatagramConnectorDelegate.this;
                    synchronized (datagramConnectorDelegate) {
                        if (DatagramConnectorDelegate.this.selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                DatagramConnectorDelegate.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

