/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.util.IdentityHashSet;

public class VmPipeAcceptor
extends BaseIoAcceptor {
    static final Map boundHandlers = new HashMap();
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoAcceptorConfig(){

        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        Map map = boundHandlers;
        synchronized (map) {
            if (boundHandlers.containsKey(address)) {
                throw new IOException("Address already bound: " + address);
            }
            boundHandlers.put(address, new VmPipe(this, (VmPipeAddress)address, handler, config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getManagedSessions(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        VmPipe pipe = null;
        Map map = boundHandlers;
        synchronized (map) {
            pipe = (VmPipe)boundHandlers.get(address);
            if (pipe == null) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
        }
        Set managedSessions = pipe.getManagedServerSessions();
        return Collections.unmodifiableSet(new IdentityHashSet(Arrays.asList(managedSessions.toArray())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        VmPipe pipe = null;
        Map map = boundHandlers;
        synchronized (map) {
            if (!boundHandlers.containsKey(address)) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            pipe = (VmPipe)boundHandlers.remove(address);
        }
        Set managedSessions = pipe.getManagedServerSessions();
        IoServiceConfig cfg = pipe.getConfig();
        boolean disconnectOnUnbind = cfg instanceof IoAcceptorConfig ? ((IoAcceptorConfig)cfg).isDisconnectOnUnbind() : ((IoAcceptorConfig)this.getDefaultConfig()).isDisconnectOnUnbind();
        if (disconnectOnUnbind && managedSessions != null) {
            IoSession[] tempSessions = managedSessions.toArray(new IoSession[0]);
            final Object lock = new Object();
            for (int i = 0; i < tempSessions.length; ++i) {
                if (!managedSessions.contains(tempSessions[i])) continue;
                tempSessions[i].close().setCallback(new IoFuture.Callback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(IoFuture future) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                });
            }
            try {
                Object i = lock;
                synchronized (i) {
                    while (!managedSessions.isEmpty()) {
                        lock.wait(1000L);
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        Map map = boundHandlers;
        synchronized (map) {
            ArrayList addresses = new ArrayList(boundHandlers.keySet());
            Iterator i = addresses.iterator();
            while (i.hasNext()) {
                this.unbind((SocketAddress)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound(SocketAddress address) {
        Map map = boundHandlers;
        synchronized (map) {
            return boundHandlers.containsKey(address);
        }
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

