/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.apache.mina.util.Queue;

public class VmPipeSessionImpl
extends BaseIoSession {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoService manager;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress serviceAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    private final Set managedSessions;
    final VmPipeSessionImpl remoteSession;
    final Object lock;
    final Queue pendingDataQueue;

    public VmPipeSessionImpl(IoService manager, Object lock, SocketAddress localAddress, IoHandler handler, IoFilterChainBuilder filterChainBuilder, ThreadModel threadModel, VmPipe remoteEntry) throws IOException {
        this.manager = manager;
        this.lock = lock;
        this.localAddress = localAddress;
        this.remoteAddress = this.serviceAddress = remoteEntry.getAddress();
        this.handler = handler;
        this.filterChain = new VmPipeFilterChain(this);
        this.pendingDataQueue = new Queue();
        this.managedSessions = remoteEntry.getManagedClientSessions();
        this.remoteSession = new VmPipeSessionImpl(manager, this, remoteEntry);
        try {
            remoteEntry.getAcceptor().getFilterChainBuilder().buildFilterChain(this.remoteSession.getFilterChain());
            remoteEntry.getConfig().getFilterChainBuilder().buildFilterChain(this.remoteSession.getFilterChain());
            remoteEntry.getConfig().getThreadModel().buildFilterChain(this.remoteSession.getFilterChain());
            ((VmPipeFilterChain)this.remoteSession.getFilterChain()).sessionCreated(this.remoteSession);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            IOException e = new IOException("Failed to initialize remote session.");
            e.initCause(t);
            throw e;
        }
        try {
            manager.getFilterChainBuilder().buildFilterChain(this.filterChain);
            filterChainBuilder.buildFilterChain(this.filterChain);
            threadModel.buildFilterChain(this.filterChain);
            handler.sessionCreated(this);
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Failed to create a session.").initCause(t);
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this.remoteSession);
        VmPipeIdleStatusChecker.getInstance().addSession(this);
        this.remoteSession.managedSessions.add(this.remoteSession);
        this.managedSessions.add(this);
        ((VmPipeFilterChain)this.remoteSession.getFilterChain()).sessionOpened(this.remoteSession);
        this.filterChain.sessionOpened(this);
    }

    private VmPipeSessionImpl(IoService manager, VmPipeSessionImpl remoteSession, VmPipe entry) {
        this.manager = manager;
        this.lock = remoteSession.lock;
        this.localAddress = this.serviceAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.pendingDataQueue = new Queue();
        this.managedSessions = entry.getManagedServerSessions();
    }

    Set getManagedSessions() {
        return this.managedSessions;
    }

    public IoService getService() {
        return this.manager;
    }

    public IoSessionConfig getConfig() {
        return CONFIG;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0() {
        this.filterChain.filterClose(this);
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.filterWrite(this, writeRequest);
    }

    public int getScheduledWriteRequests() {
        return 0;
    }

    public int getScheduledWriteBytes() {
        return 0;
    }

    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTrafficMask() {
        if (this.getTrafficMask().isReadable() || this.getTrafficMask().isWritable()) {
            Object[] data = null;
            Queue queue = this.pendingDataQueue;
            synchronized (queue) {
                data = this.pendingDataQueue.toArray();
                this.pendingDataQueue.clear();
            }
            for (int i = 0; i < data.length; ++i) {
                if (data[i] instanceof IoFilter.WriteRequest) {
                    IoFilter.WriteRequest wr = (IoFilter.WriteRequest)data[i];
                    this.filterChain.doWrite(this, wr);
                    continue;
                }
                this.filterChain.messageReceived(this, data[i]);
            }
        }
    }
}

