/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetUtil {
    public static final Logger log = LoggerFactory.getLogger((Class)CharsetUtil.class);

    public static final String getDefaultCharsetName() {
        try {
            Class<?> charsetClass = Class.forName("java.nio.charset.Charset");
            Object charSet = charsetClass.getMethod("defaultCharset", null).invoke(null, null);
            return (String)charsetClass.getMethod("name", null).invoke(charSet, null);
        }
        catch (Exception e) {
            OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
            return writer.getEncoding();
        }
    }

    public static Charset getDefaultCharset() {
        return Charset.forName(CharsetUtil.getDefaultCharsetName());
    }
}

