/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralHandlingMode;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCoreSession
implements CoreSession {
    private final DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private LdapPrincipal authorizedPrincipal;

    public DefaultCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
    }

    @Override
    public void add(ServerEntry entry) throws Exception {
        this.directoryService.getOperationManager().add(new AddOperationContext((CoreSession)this, entry));
    }

    @Override
    public void compare(LdapDN dn, String oid, Object value) throws Exception {
        this.directoryService.getOperationManager().compare(new CompareOperationContext(this, dn, oid, value));
    }

    @Override
    public void delete(LdapDN dn) throws Exception {
        this.directoryService.getOperationManager().delete(new DeleteOperationContext((CoreSession)this, dn));
    }

    @Override
    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Override
    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    @Override
    public SocketAddress getClientAddress() {
        return null;
    }

    @Override
    public Set<Control> getControls() {
        return null;
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    @Override
    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return null;
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getJndiName().toNormName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    @Override
    public EntryFilteringCursor list(LdapDN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        return this.directoryService.getOperationManager().list(new ListOperationContext((CoreSession)this, dn, aliasDerefMode, returningAttributes));
    }

    @Override
    public EntryFilteringCursor list(LdapDN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, int sizeLimit, int timeLimit) throws Exception {
        ListOperationContext opContext = new ListOperationContext((CoreSession)this, dn, aliasDerefMode, returningAttributes);
        opContext.setSizeLimit(sizeLimit);
        opContext.setTimeLimit(timeLimit);
        return this.directoryService.getOperationManager().list(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn) throws Exception {
        return this.directoryService.getOperationManager().lookup(new LookupOperationContext((CoreSession)this, dn));
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn, String[] attrId) throws Exception {
        return this.directoryService.getOperationManager().lookup(new LookupOperationContext(this, dn, attrId));
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods) throws Exception {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add((Modification)new ServerModification(this.directoryService.getRegistries(), mod));
        }
        this.directoryService.getOperationManager().modify(new ModifyOperationContext(this, dn, serverModifications));
    }

    @Override
    public void move(LdapDN dn, LdapDN newParent) throws Exception {
        this.directoryService.getOperationManager().move(new MoveOperationContext(this, dn, newParent));
    }

    @Override
    public void moveAndRename(LdapDN dn, LdapDN newParent, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        this.directoryService.getOperationManager().moveAndRename(new MoveAndRenameOperationContext(this, dn, newParent, newRdn, deleteOldRdn));
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        this.directoryService.getOperationManager().rename(new RenameOperationContext(this, dn, newRdn, deleteOldRdn));
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        return this.directoryService.getOperationManager().search(new SearchOperationContext(this, dn, scope, filter, aliasDerefMode, returningAttributes));
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, int sizeLimit, int timeLimit) throws Exception {
        SearchOperationContext opContext = new SearchOperationContext(this, dn, scope, filter, aliasDerefMode, returningAttributes);
        opContext.setSizeLimit(sizeLimit);
        opContext.setTimeLimit(timeLimit);
        return this.directoryService.getOperationManager().search(opContext);
    }

    @Override
    public boolean isAnonymous() {
        return this.getEffectivePrincipal().getJndiName().isEmpty();
    }

    @Override
    public void add(AddRequest addRequest) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, addRequest);
        this.directoryService.getOperationManager().add(opContext);
        addRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public boolean compare(CompareRequest compareRequest) throws Exception {
        CompareOperationContext opContext = new CompareOperationContext((CoreSession)this, compareRequest);
        boolean result = this.directoryService.getOperationManager().compare(opContext);
        compareRequest.getResultResponse().addAll(opContext.getResponseControls());
        return result;
    }

    @Override
    public void delete(DeleteRequest deleteRequest) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        this.directoryService.getOperationManager().delete(opContext);
        deleteRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn, Control[] requestControls, ReferralHandlingMode refMode, LdapDN authorized) throws Exception {
        LookupOperationContext opContext = new LookupOperationContext((CoreSession)this, dn);
        opContext.addRequestControls(requestControls);
        return this.directoryService.getOperationManager().lookup(opContext);
    }

    @Override
    public boolean exists(LdapDN dn) throws Exception {
        EntryOperationContext opContext = new EntryOperationContext(this, dn);
        return this.directoryService.getOperationManager().hasEntry(opContext);
    }

    @Override
    public void modify(ModifyRequest modifyRequest) throws Exception {
        ModifyOperationContext opContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        this.directoryService.getOperationManager().modify(opContext);
        modifyRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void move(ModifyDnRequest modifyDnRequest) throws Exception {
        MoveOperationContext opContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        this.directoryService.getOperationManager().move(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void moveAndRename(ModifyDnRequest modifyDnRequest) throws Exception {
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        this.directoryService.getOperationManager().moveAndRename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void rename(ModifyDnRequest modifyDnRequest) throws Exception {
        RenameOperationContext opContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        this.directoryService.getOperationManager().rename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public EntryFilteringCursor search(SearchRequest searchRequest) throws Exception {
        SearchOperationContext opContext = new SearchOperationContext((CoreSession)this, searchRequest);
        EntryFilteringCursor cursor = this.directoryService.getOperationManager().search(opContext);
        searchRequest.getResultResponse().addAll(opContext.getResponseControls());
        return cursor;
    }

    @Override
    public void unbind() throws Exception {
        this.directoryService.getOperationManager().unbind(new UnbindOperationContext(this));
    }

    @Override
    public void unbind(UnbindRequest unbindRequest) {
    }
}

