/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedByFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(Registries registries, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<LdapDN> userGroupNames, LdapDN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> ii = tuples.iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (!tuple.isGrant() || !this.isRemovable(tuple, attrId, attrValue, entry)) continue;
            ii.remove();
        }
        return tuples;
    }

    public boolean isRemovable(ACITuple tuple, String attrId, Value<?> attrValue, ServerEntry entry) throws NamingException {
        for (ProtectedItem item : tuple.getProtectedItems()) {
            if (!(item instanceof ProtectedItem.RestrictedBy)) continue;
            ProtectedItem.RestrictedBy rb = (ProtectedItem.RestrictedBy)item;
            for (ProtectedItem.RestrictedByItem rbItem : rb) {
                EntryAttribute attr;
                if (!attrId.equalsIgnoreCase(rbItem.getAttributeType()) || (attr = entry.get(rbItem.getValuesIn())) != null && attr.contains(new Value[]{attrValue})) continue;
                return true;
            }
        }
        return false;
    }
}

