/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class SubstringEvaluator
implements Evaluator {
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;

    public SubstringEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
    }

    public boolean evaluate(ExprNode node, String dn, ServerEntry entry) throws NamingException {
        Pattern regex = null;
        SubstringNode snode = (SubstringNode)node;
        String oid = this.oidRegistry.getOid(snode.getAttribute());
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        MatchingRule matchingRule = type.getSubstr();
        if (matchingRule == null) {
            matchingRule = type.getEquality();
        }
        Normalizer normalizer = matchingRule.getNormalizer();
        EntryAttribute attr = entry.get(snode.getAttribute());
        if (null == attr) {
            return false;
        }
        try {
            regex = snode.getRegex(normalizer);
        }
        catch (PatternSyntaxException pse) {
            NamingException ne = new NamingException("SubstringNode '" + node + "' had " + "incorrect syntax");
            ne.setRootCause(pse);
            throw ne;
        }
        for (Value value : attr) {
            String normValue = (String)normalizer.normalize((Object)value);
            if (!regex.matcher(normValue).matches()) continue;
            return true;
        }
        return false;
    }
}

