/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import java.util.List;
import java.util.Map;
import javax.naming.Name;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.EmptyCursor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameAlreadyBoundException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.OidNormalizer;

public class ExceptionInterceptor
extends BaseInterceptor {
    private PartitionNexus nexus;
    private DirectoryService directoryService;
    private LdapDN subschemSubentryDn;
    private Map<String, OidNormalizer> normalizerMap;
    private final LRUMap notAliasCache = new LRUMap(100);
    private static final int DEFAULT_CACHE_SIZE = 100;

    public void init(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.nexus = directoryService.getPartitionNexus();
        this.normalizerMap = directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        Value attr = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemSubentryDn = new LdapDN((String)attr.get());
        this.subschemSubentryDn.normalize(this.normalizerMap);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        boolean notAnAlias;
        LdapDN name = opContext.getDn();
        if (this.subschemSubentryDn.getNormName().equals(name.getNormName())) {
            throw new LdapNameAlreadyBoundException("The global schema subentry cannot be added since it exists by default.");
        }
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), name))) {
            LdapNameAlreadyBoundException ne = new LdapNameAlreadyBoundException(name.getUpName() + " already exists!");
            ne.setResolvedName((Name)new LdapDN(name.getUpName()));
            throw ne;
        }
        LdapDN suffix = this.nexus.getSuffix(new GetSuffixOperationContext(this.directoryService.getAdminSession(), name));
        if (suffix.getNormName().equals(name.getNormName())) {
            nextInterceptor.add(opContext);
            return;
        }
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(name.size() - 1);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey((Object)parentDn.getNormName());
        }
        if (!notAnAlias) {
            ClonedServerEntry attrs;
            try {
                attrs = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
            }
            catch (Exception e) {
                LdapNameNotFoundException e2 = new LdapNameNotFoundException("Parent " + parentDn.getUpName() + " not found");
                e2.setResolvedName((Name)new LdapDN(this.nexus.getMatchedName(new GetMatchedNameOperationContext(opContext.getSession(), parentDn)).getUpName()));
                throw e2;
            }
            EntryAttribute objectClass = attrs.getOriginalEntry().get("objectClass");
            if (objectClass.contains(new String[]{"alias"})) {
                String msg = "Attempt to add entry to alias '" + name.getUpName() + "' not allowed.";
                ResultCodeEnum rc = ResultCodeEnum.ALIAS_PROBLEM;
                LdapNamingException e = new LdapNamingException(msg, rc);
                e.setResolvedName((Name)new LdapDN(parentDn.getUpName()));
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put((Object)parentDn.getNormName(), (Object)parentDn);
            }
        }
        nextInterceptor.add(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        if (name.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the deletion of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, name);
        boolean hasChildren = false;
        EntryFilteringCursor list = nextInterceptor.list(new ListOperationContext(opContext.getSession(), name));
        if (list.next()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            e.setResolvedName((Name)new LdapDN(name.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)name.getNormName())) {
                this.notAliasCache.remove((Object)name.getNormName());
            }
        }
        nextInterceptor.delete(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new EmptyCursor(), opContext);
        }
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        return nextInterceptor.list(opContext);
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return this.nexus.getRootDSE(null);
        }
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        return nextInterceptor.lookup(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        String msg = "Attempt to modify non-existant entry: ";
        if (opContext.getDn().getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            nextInterceptor.modify(opContext);
            return;
        }
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        ClonedServerEntry entry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<Modification> items = opContext.getModItems();
        for (Modification item : items) {
            ServerAttribute modAttr;
            EntryAttribute entryAttr;
            if (item.getOperation() != ModificationOperation.ADD_ATTRIBUTE || (entryAttr = entry.get((modAttr = (ServerAttribute)item.getAttribute()).getId())) == null) continue;
            for (Value value : modAttr) {
                if (!entryAttr.contains(new Value[]{value})) continue;
                throw new LdapAttributeInUseException("Trying to add existing value '" + value + "' to attribute " + modAttr.getId());
            }
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)opContext.getDn().getNormName())) {
                this.notAliasCache.remove((Object)opContext.getDn().getNormName());
            }
        }
        nextInterceptor.modify(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        LdapDN dn = opContext.getDn();
        if (dn.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the renaming of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to rename non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, dn);
        LdapDN newDn = (LdapDN)dn.clone();
        newDn.remove(dn.size() - 1);
        newDn.add(opContext.getNewRdn());
        newDn.normalize(this.normalizerMap);
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), newDn))) {
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + newDn.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(newDn.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)dn.getNormName())) {
                this.notAliasCache.remove((Object)dn.getNormName());
            }
        }
        nextInterceptor.rename(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        LdapDN newParentName = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the move of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, newParentName);
        String rdn = oriChildName.get(oriChildName.size() - 1);
        LdapDN target = (LdapDN)newParentName.clone();
        target.add(rdn);
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            String upRdn = new LdapDN(oriChildName.getUpName()).get(oriChildName.size() - 1);
            LdapDN upTarget = (LdapDN)newParentName.clone();
            upTarget.add(upRdn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.move(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        LdapDN parent = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the move of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, parent);
        LdapDN target = (LdapDN)parent.clone();
        target.add(opContext.getNewRdn());
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            LdapDN upTarget = (LdapDN)parent.clone();
            upTarget.add(opContext.getNewRdn());
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        LdapDN base = opContext.getDn();
        try {
            EntryFilteringCursor cursor = nextInterceptor.search(opContext);
            if (!(cursor.next() || base.isEmpty() || this.subschemSubentryDn.toNormName().equalsIgnoreCase(base.toNormName()))) {
                this.assertHasEntry(nextInterceptor, opContext, "Attempt to search under non-existant entry:", base);
            }
            return cursor;
        }
        catch (Exception ne) {
            String msg = "Attempt to search under non-existant entry: ";
            this.assertHasEntry(nextInterceptor, opContext, msg, base);
            throw ne;
        }
    }

    private void assertHasEntry(NextInterceptor nextInterceptor, OperationContext opContext, String msg, LdapDN dn) throws Exception {
        if (this.subschemSubentryDn.getNormName().equals(dn.getNormName())) {
            return;
        }
        if (!opContext.hasEntry(dn, ByPassConstants.HAS_ENTRY_BYPASS)) {
            LdapNameNotFoundException e = msg != null ? new LdapNameNotFoundException(msg + dn.getUpName()) : new LdapNameNotFoundException(dn.getUpName());
            e.setResolvedName((Name)new LdapDN(opContext.getSession().getDirectoryService().getOperationManager().getMatchedName(new GetMatchedNameOperationContext(opContext.getSession(), dn)).getUpName()));
            throw e;
        }
    }
}

