/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class AddOperationContext
extends AbstractChangeOperationContext {
    public AddOperationContext(CoreSession session) {
        super(session);
    }

    public AddOperationContext(CoreSession session, LdapDN dn) {
        super(session, dn);
    }

    public AddOperationContext(CoreSession session, ServerEntry entry) {
        super(session, entry.getDn());
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, LdapDN dn, ServerEntry entry) {
        super(session, dn);
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, AddRequest addRequest) throws Exception {
        super(session);
        this.entry = new ClonedServerEntry((ServerEntry)new DefaultServerEntry(session.getDirectoryService().getRegistries(), addRequest.getEntry()));
        this.dn = addRequest.getEntry().getDn();
        this.requestControls = addRequest.getControls();
    }

    public String getName() {
        return MessageTypeEnum.ADD_REQUEST.name();
    }

    public String toString() {
        return "AddContext for DN '" + this.getDn().getUpName() + "'" + ", added entry: " + this.entry;
    }
}

