/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOperationContext
extends AbstractChangeOperationContext {
    private List<Modification> modItems;
    private ClonedServerEntry entry;

    public ModifyOperationContext(CoreSession session) {
        super(session);
    }

    public ModifyOperationContext(CoreSession session, LdapDN dn, List<Modification> modItems) {
        super(session, dn);
        this.modItems = modItems;
    }

    public ModifyOperationContext(CoreSession session, ModifyRequest modifyRequest) throws Exception {
        super(session, modifyRequest.getName());
        this.modItems = ServerEntryUtils.toServerModification((Modification[])((Modification[])modifyRequest.getModificationItems().toArray(new ClientModification[0])), (AttributeTypeRegistry)session.getDirectoryService().getRegistries().getAttributeTypeRegistry());
        this.requestControls = modifyRequest.getControls();
    }

    public void setModItems(List<Modification> modItems) {
        this.modItems = modItems;
    }

    public List<Modification> getModItems() {
        return this.modItems;
    }

    public static List<Modification> createModItems(ServerEntry serverEntry, ModificationOperation modOp) throws NamingException {
        ArrayList<Modification> items = new ArrayList<Modification>(serverEntry.size());
        for (EntryAttribute attribute : serverEntry) {
            items.add((Modification)new ServerModification(modOp, attribute));
        }
        return items;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.MODIFY_REQUEST.name();
    }

    @Override
    public void setEntry(ClonedServerEntry entry) {
        this.entry = entry;
    }

    @Override
    public ClonedServerEntry getEntry() {
        return this.entry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ModifyContext for DN '").append(this.getDn().getUpName()).append("', modifications :\n");
        for (Modification mod : this.modItems) {
            sb.append(mod).append('\n');
        }
        return sb.toString();
    }
}

