/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.Iterator;
import javax.naming.ServiceUnavailableException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationManager
implements OperationManager {
    private final DirectoryService directoryService;

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().add(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(BindOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().bind(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare(CompareOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            boolean bl = this.directoryService.getInterceptorChain().compare(opContext);
            return bl;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().delete(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            LdapDN ldapDN = this.directoryService.getInterceptorChain().getMatchedName(opContext);
            return ldapDN;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.directoryService.getInterceptorChain().getRootDSE(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapDN getSuffix(GetSuffixOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            LdapDN ldapDN = this.directoryService.getInterceptorChain().getSuffix(opContext);
            return ldapDN;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            boolean bl = this.directoryService.getInterceptorChain().hasEntry(opContext);
            return bl;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.directoryService.getInterceptorChain().list(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            Iterator<String> iterator = this.directoryService.getInterceptorChain().listSuffixes(opContext);
            return iterator;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.directoryService.getInterceptorChain().lookup(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().modify(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().move(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().moveAndRename(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().rename(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.directoryService.getInterceptorChain().search(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UnbindOperationContext opContext) throws Exception {
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().unbind(opContext);
        }
        finally {
            this.pop();
        }
    }

    private void ensureStarted() throws ServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new ServiceUnavailableException("Directory service is not started.");
        }
    }

    private void pop() {
        InvocationStack stack = InvocationStack.getInstance();
        stack.pop();
    }

    private void push(OperationContext opContext) {
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(opContext);
    }
}

