/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationInterceptor.class);
    private static LdapDN USER_BASE_DN;
    private static LdapDN GROUP_BASE_DN;
    private static LdapDN ADMIN_GROUP_DN;
    private boolean enabled = true;
    private Set<String> administrators = new HashSet<String>(2);
    private Map<String, OidNormalizer> normalizerMapping;
    private PartitionNexus nexus;
    private AttributeType uniqueMemberAT;

    public void init(DirectoryService directoryService) throws Exception {
        this.nexus = directoryService.getPartitionNexus();
        this.normalizerMapping = directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.enabled = !directoryService.isAccessControlEnabled();
        USER_BASE_DN = PartitionNexus.getUsersBaseName();
        USER_BASE_DN.normalize(this.normalizerMapping);
        GROUP_BASE_DN = PartitionNexus.getGroupsBaseName();
        GROUP_BASE_DN.normalize(this.normalizerMapping);
        ADMIN_GROUP_DN = new LdapDN("cn=Administrators,ou=groups,ou=system");
        ADMIN_GROUP_DN.normalize(this.normalizerMapping);
        AttributeTypeRegistry attrRegistry = directoryService.getRegistries().getAttributeTypeRegistry();
        this.uniqueMemberAT = attrRegistry.lookup("2.5.4.50");
        this.loadAdministrators(directoryService);
    }

    private void loadAdministrators(DirectoryService directoryService) throws Exception {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
        ClonedServerEntry adminGroup = this.nexus.lookup(new LookupOperationContext((CoreSession)adminSession, ADMIN_GROUP_DN));
        if (adminGroup == null) {
            return;
        }
        EntryAttribute uniqueMember = adminGroup.get(this.uniqueMemberAT);
        for (Value value : uniqueMember) {
            LdapDN memberDn = new LdapDN((String)value.get());
            memberDn.normalize(this.normalizerMapping);
            newAdministrators.add(memberDn.getNormName());
        }
        this.administrators = newAdministrators;
    }

    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        if (!this.enabled) {
            nextInterceptor.delete(opContext);
            return;
        }
        LdapDN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getJndiName();
        if (name.isEmpty()) {
            String msg = "The rootDSE cannot be deleted!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = "The Administrators group cannot be deleted!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(name)) {
            String msg = "User " + principalDn.getUpName();
            msg = msg + " does not have permission to delete the admin account.";
            msg = msg + " No one not even the admin can delete this account!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (name.startsWith((Name)USER_BASE_DN)) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to delete the user account: ";
                msg = msg + name.getUpName() + ". Only the admin can delete user accounts.";
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (name.startsWith((Name)GROUP_BASE_DN)) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to delete the group entry: ";
                msg = msg + name.getUpName() + ". Only the admin can delete groups.";
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
        nextInterceptor.delete(opContext);
    }

    private boolean isTheAdministrator(LdapDN normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    private boolean isAnAdministrator(LdapDN normalizedDn) {
        return this.isTheAdministrator(normalizedDn) || this.administrators.contains(normalizedDn.getNormName());
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        if (this.enabled) {
            LdapDN dn = opContext.getDn();
            this.protectModifyAlterations(dn);
            nextInterceptor.modify(opContext);
            if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
                this.loadAdministrators(opContext.getSession().getDirectoryService());
            }
        } else {
            nextInterceptor.modify(opContext);
        }
    }

    private void protectModifyAlterations(LdapDN dn) throws Exception {
        LdapDN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getJndiName();
        if (dn.isEmpty()) {
            String msg = "The rootDSE cannot be modified!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.getNormName().equals(DefaultAuthorizationInterceptor.getPrincipal().getJndiName().getNormName())) {
                return;
            }
            if (dn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to modify the account of the";
                msg = msg + " admin user.";
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2) {
                if (dn.startsWith((Name)USER_BASE_DN)) {
                    String msg = "User " + principalDn.getUpName();
                    msg = msg + " does not have permission to modify the account of the";
                    msg = msg + " user " + dn.getUpName() + ".\nEven the owner of an account cannot";
                    msg = msg + " modify it.\nUser accounts can only be modified by the";
                    msg = msg + " administrator.";
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.startsWith((Name)GROUP_BASE_DN)) {
                    String msg = "User " + principalDn.getUpName();
                    msg = msg + " does not have permission to modify the group entry ";
                    msg = msg + dn.getUpName() + ".\nGroups can only be modified by the admin.";
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
        }
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.rename(opContext);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.move(opContext);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.moveAndRename(opContext);
    }

    private void protectDnAlterations(LdapDN dn) throws Exception {
        LdapDN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getJndiName();
        if (dn.isEmpty()) {
            String msg = "The rootDSE cannot be moved or renamed!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = "The Administrators group cannot be moved or renamed!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the admin";
            msg = msg + " account.  No one not even the admin can move or";
            msg = msg + " rename " + dn.getUpName() + "!";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)USER_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the user";
            msg = msg + " account: " + dn.getUpName() + ". Only the admin can move or";
            msg = msg + " rename user accounts.";
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)GROUP_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User " + principalDn.getUpName();
            msg = msg + " does not have permission to move or rename the group entry ";
            msg = msg + dn.getUpName() + ".\nGroups can only be moved or renamed by the admin.";
            throw new LdapNoPermissionException(msg);
        }
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry serverEntry = nextInterceptor.lookup(opContext);
        if (!this.enabled || serverEntry == null) {
            return serverEntry;
        }
        this.protectLookUp(opContext.getSession().getEffectivePrincipal().getJndiName(), opContext.getDn());
        return serverEntry;
    }

    private void protectLookUp(LdapDN principalDn, LdapDN normalizedDn) throws Exception {
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2) {
                if (normalizedDn.startsWith((Name)USER_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = "Access to user account '" + normalizedDn.getUpName() + "' not permitted";
                    msg = msg + " for user '" + principalDn.getUpName() + "'.  Only the admin can";
                    msg = msg + " access user account information";
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (normalizedDn.startsWith((Name)GROUP_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = "Access to group '" + normalizedDn.getUpName() + "' not permitted";
                    msg = msg + " for user '" + principalDn.getUpName() + "'.  Only the admin can";
                    msg = msg + " access group information";
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = "Access to admin account not permitted for user '";
                msg = msg + principalDn.getUpName() + "'.  Only the admin can";
                msg = msg + " access admin account information";
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (!this.enabled) {
            return cursor;
        }
        cursor.addEntryFilter(new EntryFilter(){

            public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
                return DefaultAuthorizationInterceptor.this.isSearchable(operation, result);
            }
        });
        return cursor;
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        if (!this.enabled) {
            return cursor;
        }
        cursor.addEntryFilter(new EntryFilter(){

            public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
                return DefaultAuthorizationInterceptor.this.isSearchable(operation, entry);
            }
        });
        return cursor;
    }

    private boolean isSearchable(OperationContext opContext, ClonedServerEntry result) throws Exception {
        LdapDN principalDn = opContext.getSession().getEffectivePrincipal().getJndiName();
        LdapDN dn = result.getDn();
        if (!dn.isNormalized()) {
            dn.normalize(this.normalizerMapping);
        }
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.getNormName().equals(principalDn.getNormName());
        if (isSelfRead) {
            return true;
        }
        if (dn.size() > 2 && (dn.getNormName().endsWith(USER_BASE_DN.getNormName()) || dn.getNormName().endsWith(GROUP_BASE_DN.getNormName()))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }
}

