/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupCache {
    private static final Logger LOG = LoggerFactory.getLogger(GroupCache.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Map<String, Set<String>> groups = new HashMap<String, Set<String>>();
    private final PartitionNexus nexus;
    private AttributeType memberAT;
    private AttributeType uniqueMemberAT;
    private Map<String, OidNormalizer> normalizerMap;
    private LdapDN administratorsGroupDn;
    private static final Set<LdapDN> EMPTY_GROUPS = new HashSet<LdapDN>();

    public GroupCache(CoreSession session) throws Exception {
        this.normalizerMap = session.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = session.getDirectoryService().getPartitionNexus();
        AttributeTypeRegistry attributeTypeRegistry = session.getDirectoryService().getRegistries().getAttributeTypeRegistry();
        this.memberAT = attributeTypeRegistry.lookup("2.5.4.31");
        this.uniqueMemberAT = attributeTypeRegistry.lookup("2.5.4.50");
        this.administratorsGroupDn = this.parseNormalized("cn=Administrators,ou=groups,ou=system");
        this.initialize(session);
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize(CoreSession session) throws Exception {
        OrNode filter = new OrNode();
        filter.addNode((ExprNode)new EqualityNode("objectClass", (Value)new ClientStringValue("groupOfNames")));
        filter.addNode((ExprNode)new EqualityNode("objectClass", (Value)new ClientStringValue("groupOfUniqueNames")));
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            String suffix = suffixes.next();
            LdapDN baseDn = new LdapDN(suffix);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            EntryFilteringCursor results = this.nexus.search(new SearchOperationContext(session, baseDn, AliasDerefMode.DEREF_ALWAYS, (ExprNode)filter, ctls));
            while (results.next()) {
                ServerEntry result = (ServerEntry)results.get();
                LdapDN groupDn = result.getDn().normalize(this.normalizerMap);
                EntryAttribute members = this.getMemberAttribute(result);
                if (members != null) {
                    HashSet<String> memberSet = new HashSet<String>(members.size());
                    this.addMembers(memberSet, members);
                    this.groups.put(groupDn.getNormName(), memberSet);
                    continue;
                }
                LOG.warn("Found group '{}' without any member or uniqueMember attributes", (Object)groupDn.getUpName());
            }
            results.close();
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents on startup:\n {}", this.groups);
        }
    }

    private EntryAttribute getMemberAttribute(ServerEntry entry) throws NamingException {
        EntryAttribute oc = entry.get("objectClass");
        if (oc == null) {
            EntryAttribute member = entry.get(this.memberAT);
            if (member != null) {
                return member;
            }
            EntryAttribute uniqueMember = entry.get(this.uniqueMemberAT);
            if (uniqueMember != null) {
                return uniqueMember;
            }
            return null;
        }
        if (oc.contains(new String[]{"groupOfNames"}) || oc.contains(new String[]{"2.5.6.9"})) {
            return entry.get(this.memberAT);
        }
        if (oc.contains(new String[]{"groupOfUniqueNames"}) || oc.contains(new String[]{"2.5.6.17"})) {
            return entry.get(this.uniqueMemberAT);
        }
        return null;
    }

    private void addMembers(Set<String> memberSet, EntryAttribute members) throws NamingException {
        for (Value value : members) {
            String memberDn = (String)value.get();
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                LOG.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not added to GroupCache.", (Throwable)e);
            }
            memberSet.add(memberDn);
        }
    }

    private void removeMembers(Set<String> memberSet, EntryAttribute members) throws NamingException {
        for (Value value : members) {
            String memberDn = (String)value.get();
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                LOG.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not removed from GroupCache.", (Throwable)e);
            }
            memberSet.remove(memberDn);
        }
    }

    public void groupAdded(LdapDN name, ServerEntry entry) throws NamingException {
        EntryAttribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        HashSet<String> memberSet = new HashSet<String>(members.size());
        this.addMembers(memberSet, members);
        this.groups.put(name.getNormName(), memberSet);
        if (IS_DEBUG) {
            LOG.debug("group cache contents after adding '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public void groupDeleted(LdapDN name, ServerEntry entry) throws NamingException {
        EntryAttribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        this.groups.remove(name.getNormName());
        if (IS_DEBUG) {
            LOG.debug("group cache contents after deleting '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    private void modify(Set<String> memberSet, ModificationOperation modOp, EntryAttribute members) throws NamingException {
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                this.addMembers(memberSet, members);
                break;
            }
            case REPLACE_ATTRIBUTE: {
                if (members.size() <= 0) break;
                memberSet.clear();
                this.addMembers(memberSet, members);
                break;
            }
            case REMOVE_ATTRIBUTE: {
                this.removeMembers(memberSet, members);
                break;
            }
            default: {
                throw new InternalError("Undefined modify operation value of " + modOp);
            }
        }
    }

    public void groupModified(LdapDN name, List<Modification> mods, ServerEntry entry, Registries registries) throws NamingException {
        EntryAttribute members = null;
        String memberAttrId = null;
        EntryAttribute oc = entry.get("objectClass");
        if (oc.contains(new String[]{"groupOfNames"})) {
            members = entry.get(this.memberAT);
            memberAttrId = "member";
        }
        if (oc.contains(new String[]{"groupOfUniqueNames"})) {
            members = entry.get(this.uniqueMemberAT);
            memberAttrId = "uniqueMember";
        }
        if (members == null) {
            return;
        }
        for (Modification modification : mods) {
            if (!memberAttrId.equalsIgnoreCase(modification.getAttribute().getId())) continue;
            Set<String> memberSet = this.groups.get(name.getNormName());
            if (memberSet == null) break;
            this.modify(memberSet, modification.getOperation(), (EntryAttribute)((ServerAttribute)modification.getAttribute()));
            break;
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public void groupModified(LdapDN name, ModificationOperation modOp, ServerEntry mods) throws NamingException {
        EntryAttribute members = this.getMemberAttribute(mods);
        if (members == null) {
            return;
        }
        Set<String> memberSet = this.groups.get(name.getNormName());
        if (memberSet != null) {
            this.modify(memberSet, modOp, members);
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) {
        if (principalDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
            return true;
        }
        Set<String> members = this.groups.get(this.administratorsGroupDn.getNormName());
        if (members == null) {
            LOG.warn("What do you mean there is no administrators group? This is bad news.");
            return false;
        }
        return members.contains(principalDn.toNormName());
    }

    public Set<LdapDN> getGroups(String member) throws NamingException {
        LdapDN normMember;
        try {
            normMember = this.parseNormalized(member);
        }
        catch (NamingException e) {
            LOG.warn("Malformed member DN.  Could not find groups for member '{}' in GroupCache. Returning empty set for groups!", (Object)member, (Object)e);
            return EMPTY_GROUPS;
        }
        HashSet<LdapDN> memberGroups = null;
        for (String group : this.groups.keySet()) {
            Set<String> members = this.groups.get(group);
            if (members == null || !members.contains(normMember.getNormName())) continue;
            if (memberGroups == null) {
                memberGroups = new HashSet<LdapDN>();
            }
            memberGroups.add(this.parseNormalized(group));
        }
        if (memberGroups == null) {
            return EMPTY_GROUPS;
        }
        return memberGroups;
    }

    public boolean groupRenamed(LdapDN oldName, LdapDN newName) {
        Set<String> members = this.groups.remove(oldName.getNormName());
        if (members != null) {
            this.groups.put(newName.getNormName(), members);
            if (IS_DEBUG) {
                LOG.debug("group cache contents after renaming '{}' :\n{}", (Object)oldName.getUpName(), this.groups);
            }
            return true;
        }
        return false;
    }
}

