/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeLogInterceptor.class);
    private AttributeType entryDeleted;
    private ChangeLog changeLog;
    private SchemaService schemaService;
    private static final String REV_OID = "1.3.6.1.4.1.18060.0.4.1.2.47";

    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.changeLog = directoryService.getChangeLog();
        this.schemaService = directoryService.getSchemaService();
        this.entryDeleted = directoryService.getRegistries().getAttributeTypeRegistry().lookup("1.3.6.1.4.1.18060.0.4.1.2.31");
    }

    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        next.add(opContext);
        if (!this.changeLog.isEnabled() || !opContext.isFirstOperation()) {
            return;
        }
        ClonedServerEntry addEntry = opContext.getEntry();
        if (addEntry.get(REV_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Add);
        forward.setDn(opContext.getDn());
        Set list = addEntry.getAttributeTypes();
        for (AttributeType attributeType : list) {
            forward.addAttribute(((ServerAttribute)addEntry.get(attributeType)).toClientAttribute());
        }
        LdifEntry reverse = LdifUtils.reverseAdd((LdapDN)opContext.getDn());
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        ServerEntry serverEntry = null;
        if (this.changeLog.isEnabled() && opContext.isFirstOperation()) {
            serverEntry = this.getAttributes(opContext);
        }
        next.delete(opContext);
        if (!this.changeLog.isEnabled() || !opContext.isFirstOperation()) {
            return;
        }
        if (serverEntry.get(REV_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Delete);
        forward.setDn(opContext.getDn());
        DefaultClientEntry reverseEntry = new DefaultClientEntry(serverEntry.getDn());
        for (EntryAttribute attribute : serverEntry) {
            reverseEntry.add(new EntryAttribute[]{((ServerAttribute)attribute).toClientAttribute()});
        }
        LdifEntry reverse = LdifUtils.reverseDel((LdapDN)opContext.getDn(), (Entry)reverseEntry);
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    private ServerEntry getAttributes(OperationContext opContext) throws Exception {
        LdapDN dn = opContext.getDn();
        if (this.schemaService.isSchemaSubentry(dn.toNormName())) {
            return this.schemaService.getSubschemaEntryCloned();
        }
        ClonedServerEntry serverEntry = opContext.lookup(dn, ByPassConstants.LOOKUP_BYPASS);
        return serverEntry;
    }

    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        boolean isDelete;
        ServerEntry serverEntry = null;
        Modification modification = ServerEntryUtils.getModificationItem(opContext.getModItems(), (AttributeType)this.entryDeleted);
        boolean bl = isDelete = modification != null;
        if (!isDelete && this.changeLog.isEnabled() && opContext.isFirstOperation()) {
            serverEntry = this.getAttributes(opContext);
        }
        next.modify(opContext);
        if (isDelete || !this.changeLog.isEnabled() || !opContext.isFirstOperation() || opContext.getModItems().size() == 0) {
            if (isDelete) {
                LOG.debug("Bypassing changelog on modify of entryDeleted attribute.");
            }
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Modify);
        forward.setDn(opContext.getDn());
        ArrayList<Modification> mods = new ArrayList<Modification>(opContext.getModItems().size());
        for (Modification modItem : opContext.getModItems()) {
            Modification mod = ((ServerModification)modItem).toClientModification();
            mod.getAttribute().setId(modItem.getAttribute().getId());
            mods.add(mod);
            forward.addModificationItem(mod);
        }
        DefaultClientEntry clientEntry = new DefaultClientEntry(serverEntry.getDn());
        for (EntryAttribute attribute : serverEntry) {
            clientEntry.add(new EntryAttribute[]{((ServerAttribute)attribute).toClientAttribute()});
        }
        LdifEntry reverse = LdifUtils.reverseModify((LdapDN)opContext.getDn(), mods, (Entry)clientEntry);
        opContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws Exception {
        ServerEntry serverEntry = null;
        if (this.changeLog.isEnabled() && renameContext.isFirstOperation()) {
            serverEntry = this.getAttributes(renameContext);
        }
        next.rename(renameContext);
        if (!this.changeLog.isEnabled() || !renameContext.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModRdn);
        forward.setDn(renameContext.getDn());
        forward.setNewRdn(renameContext.getNewRdn().getUpName());
        forward.setDeleteOldRdn(renameContext.getDelOldDn());
        List reverses = LdifUtils.reverseModifyRdn((Attributes)ServerEntryUtils.toBasicAttributes((ServerEntry)serverEntry), null, (LdapDN)renameContext.getDn(), (Rdn)new Rdn(renameContext.getNewRdn()));
        renameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opCtx) throws Exception {
        ClonedServerEntry serverEntry = null;
        if (this.changeLog.isEnabled() && opCtx.isFirstOperation()) {
            serverEntry = opCtx.lookup(opCtx.getDn(), ByPassConstants.LOOKUP_BYPASS);
        }
        next.moveAndRename(opCtx);
        if (!this.changeLog.isEnabled() || !opCtx.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(opCtx.getDn());
        forward.setDeleteOldRdn(opCtx.getDelOldDn());
        forward.setNewRdn(opCtx.getNewRdn().getUpName());
        forward.setNewSuperior(opCtx.getParent().getUpName());
        List reverses = LdifUtils.reverseModifyRdn((Attributes)ServerEntryUtils.toBasicAttributes((ServerEntry)serverEntry), (LdapDN)opCtx.getParent(), (LdapDN)opCtx.getDn(), (Rdn)new Rdn(opCtx.getNewRdn()));
        opCtx.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void move(NextInterceptor next, MoveOperationContext opCtx) throws Exception {
        next.move(opCtx);
        if (!this.changeLog.isEnabled() || !opCtx.isFirstOperation()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(opCtx.getDn());
        forward.setNewSuperior(opCtx.getParent().getUpName());
        LdifEntry reverse = LdifUtils.reverseModifyDn((LdapDN)opCtx.getParent(), (LdapDN)opCtx.getDn());
        opCtx.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }
}

