/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.collective.CollectiveAttributesSchemaChecker;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectiveAttributeInterceptor
extends BaseInterceptor {
    private AttributeTypeRegistry atRegistry;
    private PartitionNexus nexus;
    private CollectiveAttributesSchemaChecker collectiveAttributesSchemaChecker;
    private final EntryFilter SEARCH_FILTER = new EntryFilter(){

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
            LdapDN name = result.getDn();
            if (!name.isNormalized()) {
                name = LdapDN.normalize((LdapDN)name, (Map)CollectiveAttributeInterceptor.this.atRegistry.getNormalizerMapping());
            }
            String[] retAttrs = operation.getSearchControls().getReturningAttributes();
            CollectiveAttributeInterceptor.this.addCollectiveAttributes(operation, result, retAttrs);
            return true;
        }
    };

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.atRegistry = directoryService.getRegistries().getAttributeTypeRegistry();
        this.collectiveAttributesSchemaChecker = new CollectiveAttributesSchemaChecker(this.nexus, this.atRegistry);
    }

    private void addCollectiveAttributes(OperationContext opContext, ClonedServerEntry entry, String[] retAttrs) throws Exception {
        EntryAttribute collectiveAttributeSubentries = entry.getOriginalEntry().get("collectiveAttributeSubentries");
        if (collectiveAttributeSubentries == null) {
            return;
        }
        EntryAttribute collectiveExclusions = entry.getOriginalEntry().get("collectiveExclusions");
        HashSet<String> exclusions = new HashSet<String>();
        if (collectiveExclusions != null) {
            if (collectiveExclusions.contains(new String[]{"2.5.18.0"}) || collectiveExclusions.contains(new String[]{"excludeAllCollectiveAttributes"})) {
                return;
            }
            exclusions = new HashSet();
            for (Value value : collectiveExclusions) {
                AttributeType attrType = this.atRegistry.lookup((String)value.get());
                exclusions.add(attrType.getOid());
            }
        }
        if (retAttrs == null) {
            retAttrs = SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY;
        }
        HashSet<String> retIdsSet = new HashSet<String>(retAttrs.length);
        for (String retAttr : retAttrs) {
            if (retAttr.equals("*") || retAttr.equals("+")) {
                retIdsSet.add(retAttr);
                continue;
            }
            retIdsSet.add(this.atRegistry.lookup(retAttr).getOid());
        }
        for (Value value : collectiveAttributeSubentries) {
            String subentryDnStr = (String)value.get();
            LdapDN subentryDn = new LdapDN(subentryDnStr);
            ClonedServerEntry subentry = opContext.lookup(subentryDn, ByPassConstants.LOOKUP_COLLECTIVE_BYPASS);
            for (AttributeType attributeType : subentry.getAttributeTypes()) {
                String attrId = attributeType.getName();
                if (!attributeType.isCollective() || exclusions.contains(attributeType.getOid())) continue;
                Set<AttributeType> allSuperTypes = this.getAllSuperTypes(attributeType);
                for (String retId : retIdsSet) {
                    AttributeType retType;
                    if (retId.equals("*") || retId.equals("+") || !allSuperTypes.contains(retType = this.atRegistry.lookup(retId))) continue;
                    retIdsSet.add(this.atRegistry.lookup(attrId).getOid());
                    break;
                }
                if (!retIdsSet.contains("*") && !retIdsSet.contains(this.atRegistry.lookup(attrId).getOid())) continue;
                EntryAttribute subentryColAttr = subentry.get(attrId);
                EntryAttribute entryColAttr = entry.get(attrId);
                if (entryColAttr == null) {
                    entryColAttr = new DefaultServerAttribute(attrId, this.atRegistry.lookup(attrId));
                    entry.put(new EntryAttribute[]{entryColAttr});
                }
                for (Value subentryColVal : subentryColAttr) {
                    entryColAttr.add(new String[]{(String)subentryColVal.get()});
                }
            }
        }
    }

    private Set<AttributeType> getAllSuperTypes(AttributeType id) throws Exception {
        HashSet<AttributeType> allSuperTypes = new HashSet<AttributeType>();
        AttributeType superType = id;
        while (superType != null) {
            if ((superType = superType.getSuperior()) == null) continue;
            allSuperTypes.add(superType);
        }
        return allSuperTypes;
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        if (opContext.getAttrsId() == null || opContext.getAttrsId().size() == 0) {
            this.addCollectiveAttributes(opContext, result, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        } else {
            this.addCollectiveAttributes(opContext, result, opContext.getAttrsIdArray());
        }
        return result;
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        this.collectiveAttributesSchemaChecker.checkAdd(opContext.getDn(), (ServerEntry)opContext.getEntry());
        next.add(opContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        this.collectiveAttributesSchemaChecker.checkModify(opContext, opContext.getDn(), opContext.getModItems());
        next.modify(opContext);
    }
}

