/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.ByteBuffer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizingVisitor
implements FilterVisitor {
    private static final Logger log = LoggerFactory.getLogger(NormalizingVisitor.class);
    private final NameComponentNormalizer ncn;
    private final Registries registries;
    private static final boolean[] FILTER_CHAR = new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static boolean isFilterChar(char c) {
        return (c | 0x7F) == 127 && FILTER_CHAR[c & 0x7F];
    }

    private static final String decodeEscapedHex(String str) throws InvalidNameException {
        StringBuffer buf = new StringBuffer();
        ByteBuffer bb = new ByteBuffer();
        boolean escaped = false;
        for (int ii = 0; ii < str.length(); ++ii) {
            char c = str.charAt(ii);
            if (c == '\\') {
                if (StringTools.isHex((String)str, (int)(ii + 1)) && StringTools.isHex((String)str, (int)(ii + 2))) {
                    bb.clear();
                    int advancedBy = StringTools.collectEscapedHexBytes((ByteBuffer)bb, (String)str, (int)ii);
                    ii += advancedBy - 1;
                    buf.append(StringTools.utf8ToString((byte[])bb.buffer(), (int)bb.position()));
                    escaped = false;
                    continue;
                }
                if (!escaped) {
                    escaped = true;
                    continue;
                }
            }
            if (escaped) {
                if (NormalizingVisitor.isFilterChar(c)) {
                    escaped = false;
                    buf.append(c);
                    continue;
                }
                throw new InvalidNameException("The value must contain valid escaped characters.");
            }
            buf.append(str.charAt(ii));
        }
        if (escaped) {
            throw new InvalidNameException("The value must not ends with a '\\'.");
        }
        return buf.toString();
    }

    private void unescapeValue(Value<?> value) {
        if (!value.isBinary()) {
            String valStr = (String)value.getNormalizedValue();
            if (StringTools.isEmpty((String)valStr)) {
                return;
            }
            try {
                String newStr = NormalizingVisitor.decodeEscapedHex(valStr);
                ((ClientStringValue)value).set(newStr);
                return;
            }
            catch (InvalidNameException ine) {
                value.set(null);
                return;
            }
        }
    }

    public NormalizingVisitor(NameComponentNormalizer ncn, Registries registries) {
        this.ncn = ncn;
        this.registries = registries;
    }

    private Value<?> normalizeValue(String attribute, Value<?> value) {
        try {
            ClientStringValue normalized = null;
            AttributeType attributeType = this.registries.getAttributeTypeRegistry().lookup(attribute);
            if (attributeType.getSyntax().isHumanReadable()) {
                if (value.isBinary()) {
                    normalized = new ClientStringValue((String)this.ncn.normalizeByName(attribute, StringTools.utf8ToString((byte[])((byte[])value.get()))));
                    this.unescapeValue((Value<?>)normalized);
                } else {
                    normalized = new ClientStringValue((String)this.ncn.normalizeByName(attribute, (String)value.get()));
                    this.unescapeValue((Value<?>)normalized);
                }
            } else {
                normalized = value.isBinary() ? new ClientBinaryValue((byte[])this.ncn.normalizeByName(attribute, (byte[])value.get())) : new ClientBinaryValue((byte[])this.ncn.normalizeByName(attribute, (String)value.get()));
            }
            return normalized;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter value: {}", (Object)ne.getMessage(), (Object)ne);
            return null;
        }
    }

    private ExprNode visitPresenceNode(PresenceNode node) {
        try {
            node.setAttribute(this.registries.getOidRegistry().getOid(node.getAttribute()));
            return node;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter node attribute: {}, error: {}", (Object)node.getAttribute(), (Object)ne.getMessage());
            return null;
        }
    }

    private ExprNode visitSimpleNode(SimpleNode node) {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        Value<?> normalized = this.normalizeValue(node.getAttribute(), node.getValue());
        if (normalized == null) {
            return null;
        }
        try {
            node.setAttribute(this.registries.getOidRegistry().getOid(node.getAttribute()));
            node.setValue(normalized);
            return node;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter node attribute: {}, error: {}", (Object)node.getAttribute(), (Object)ne.getMessage());
            return null;
        }
    }

    private ExprNode visitSubstringNode(SubstringNode node) {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        Value<?> normInitial = null;
        if (node.getInitial() != null && (normInitial = this.normalizeValue(node.getAttribute(), (Value<?>)new ClientStringValue(node.getInitial()))) == null) {
            return null;
        }
        ArrayList<String> normAnys = null;
        if (node.getAny() != null && node.getAny().size() != 0) {
            normAnys = new ArrayList<String>(node.getAny().size());
            for (String any : node.getAny()) {
                Value<?> normAny = this.normalizeValue(node.getAttribute(), (Value<?>)new ClientStringValue(any));
                if (normAny == null) continue;
                normAnys.add((String)normAny.get());
            }
            if (normAnys.size() == 0) {
                return null;
            }
        }
        Value<?> normFinal = null;
        if (node.getFinal() != null && (normFinal = this.normalizeValue(node.getAttribute(), (Value<?>)new ClientStringValue(node.getFinal()))) == null) {
            return null;
        }
        try {
            node.setAttribute(this.registries.getOidRegistry().getOid(node.getAttribute()));
            if (normInitial != null) {
                node.setInitial((String)normInitial.get());
            } else {
                node.setInitial(null);
            }
            node.setAny(normAnys);
            if (normFinal != null) {
                node.setFinal((String)normFinal.get());
            } else {
                node.setFinal(null);
            }
            return node;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter node attribute: {}, error: {}", (Object)node.getAttribute(), (Object)ne.getMessage());
            return null;
        }
    }

    private ExprNode visitExtensibleNode(ExtensibleNode node) {
        try {
            node.setAttribute(this.registries.getOidRegistry().getOid(node.getAttribute()));
            return node;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter node attribute: {}, error: {}", (Object)node.getAttribute(), (Object)ne.getMessage());
            return null;
        }
    }

    private ExprNode visitBranchNode(BranchNode node) {
        if (node instanceof NotNode) {
            ExprNode child = node.getFirstChild();
            ExprNode result = (ExprNode)this.visit(child);
            if (result == null) {
                return result;
            }
            if (result instanceof BranchNode) {
                node.setChildren(((BranchNode)result).getChildren());
                return node;
            }
            if (result instanceof LeafNode) {
                ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(1);
                newChildren.add(result);
                node.setChildren(newChildren);
                return node;
            }
        } else {
            BranchNode branchNode = node;
            List children = node.getChildren();
            ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(children.size());
            for (int i = 0; i < children.size(); ++i) {
                ExprNode child = (ExprNode)children.get(i);
                ExprNode result = (ExprNode)this.visit(child);
                if (result == null) continue;
                newChildren.add(result);
            }
            if (branchNode instanceof AndNode && newChildren.size() != children.size()) {
                return null;
            }
            if (newChildren.size() == 0) {
                return null;
            }
            if (newChildren.size() == 1) {
                return (ExprNode)newChildren.get(0);
            }
            branchNode.setChildren(newChildren);
        }
        return node;
    }

    public Object visit(ExprNode node) {
        if (node instanceof PresenceNode) {
            return this.visitPresenceNode((PresenceNode)node);
        }
        if (node instanceof BranchNode) {
            return this.visitBranchNode((BranchNode)node);
        }
        if (node instanceof SimpleNode) {
            return this.visitSimpleNode((SimpleNode)node);
        }
        if (node instanceof ExtensibleNode) {
            return this.visitExtensibleNode((ExtensibleNode)node);
        }
        if (node instanceof SubstringNode) {
            return this.visitSubstringNode((SubstringNode)node);
        }
        return null;
    }

    public boolean canVisit(ExprNode node) {
        return true;
    }

    public boolean isPrefix() {
        return false;
    }

    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }
}

