/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.ServerEntryCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionViewer;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreePartition
implements Partition {
    protected static final Set<String> SYS_INDEX_OIDS;
    protected SearchEngine<ServerEntry> searchEngine;
    protected Optimizer optimizer;
    protected Registries registries;
    protected String id;
    protected int cacheSize = -1;
    protected LdapDN suffixDn;
    protected String suffix;
    protected ServerEntry contextEntry;

    protected BTreePartition() {
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public abstract void setRegistries(Registries var1) throws Exception;

    public SearchEngine<ServerEntry> getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public void delete(DeleteOperationContext opContext) throws Exception {
        LdapDN dn = opContext.getDn();
        Long id = this.getEntryId(dn.getNormName());
        if (id == null) {
            throw new LdapNameNotFoundException("Could not find entry at '" + dn + "' to delete it!");
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException("[66] Cannot delete entry " + dn + " it has children!");
            cnee.setRemainingName((Name)dn);
            throw cnee;
        }
        this.delete(id);
    }

    @Override
    public abstract void add(AddOperationContext var1) throws Exception;

    @Override
    public abstract void modify(ModifyOperationContext var1) throws Exception;

    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor(this, this.list(this.getEntryId(opContext.getDn().getNormName()))), opContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        SearchControls searchCtls = opContext.getSearchControls();
        IndexCursor underlying = this.searchEngine.cursor(opContext.getDn(), opContext.getAliasDerefMode(), opContext.getFilter(), searchCtls);
        return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor(this, (IndexCursor<Long, ServerEntry>)underlying), opContext);
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        Long id = this.getEntryId(opContext.getDn().getNormName());
        if (id == null) {
            return null;
        }
        ClonedServerEntry entry = this.lookup(id);
        if (opContext.getAttrsId() == null || opContext.getAttrsId().size() == 0) {
            return entry;
        }
        for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
            if (opContext.getAttrsId().contains(attributeType.getOid())) continue;
            entry.removeAttributes(new AttributeType[]{attributeType});
        }
        return entry;
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        return null != this.getEntryId(opContext.getDn().getNormName());
    }

    @Override
    public abstract void rename(RenameOperationContext var1) throws Exception;

    @Override
    public abstract void move(MoveOperationContext var1) throws Exception;

    @Override
    public abstract void moveAndRename(MoveAndRenameOperationContext var1) throws Exception;

    @Override
    public abstract void sync() throws Exception;

    @Override
    public abstract void destroy() throws Exception;

    @Override
    public abstract boolean isInitialized();

    public void inspect() throws Exception {
        PartitionViewer viewer = new PartitionViewer(this, this.registries);
        viewer.execute();
    }

    public abstract void addIndexOn(Index<Long, ServerEntry> var1) throws Exception;

    public abstract boolean hasUserIndexOn(String var1) throws Exception;

    public abstract boolean hasSystemIndexOn(String var1) throws Exception;

    public abstract Index<String, ServerEntry> getPresenceIndex();

    public abstract Index<Long, ServerEntry> getOneLevelIndex();

    public abstract Index<Long, ServerEntry> getSubLevelIndex();

    public abstract Index<String, ServerEntry> getUpdnIndex();

    public abstract Index<String, ServerEntry> getNdnIndex();

    public abstract Index<Long, ServerEntry> getOneAliasIndex();

    public abstract Index<Long, ServerEntry> getSubAliasIndex();

    public abstract Index<String, ServerEntry> getAliasIndex();

    public abstract void setAliasIndexOn(Index<String, ServerEntry> var1) throws Exception;

    public abstract void setPresenceIndexOn(Index<String, ServerEntry> var1) throws Exception;

    public abstract void setOneLevelIndexOn(Index<Long, ServerEntry> var1) throws Exception;

    public abstract void setUpdnIndexOn(Index<String, ServerEntry> var1) throws Exception;

    public abstract void setNdnIndexOn(Index<String, ServerEntry> var1) throws Exception;

    public abstract void setOneAliasIndexOn(Index<Long, ServerEntry> var1) throws Exception;

    public abstract void setSubAliasIndexOn(Index<Long, ServerEntry> var1) throws Exception;

    public abstract Index<?, ServerEntry> getUserIndex(String var1) throws Exception;

    public abstract Index<?, ServerEntry> getSystemIndex(String var1) throws Exception;

    public abstract Long getEntryId(String var1) throws Exception;

    public abstract String getEntryDn(Long var1) throws Exception;

    public abstract Long getParentId(String var1) throws Exception;

    public abstract Long getParentId(Long var1) throws Exception;

    public abstract String getEntryUpdn(Long var1) throws Exception;

    public abstract String getEntryUpdn(String var1) throws Exception;

    @Override
    public abstract ClonedServerEntry lookup(Long var1) throws Exception;

    public abstract void delete(Long var1) throws Exception;

    public abstract IndexCursor<Long, ServerEntry> list(Long var1) throws Exception;

    public abstract int getChildCount(Long var1) throws Exception;

    public abstract void setProperty(String var1, String var2) throws Exception;

    public abstract String getProperty(String var1) throws Exception;

    public abstract Iterator<String> getUserIndices();

    public abstract Iterator<String> getSystemIndices();

    public abstract int count() throws Exception;

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("1.3.6.1.4.1.18060.0.4.1.2.7");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.3");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.4");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.1");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.5");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.6");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.2");
        SYS_INDEX_OIDS = Collections.unmodifiableSet(set);
    }
}

