/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStore;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmPartition
extends BTreePartition {
    private JdbmStore<ServerEntry> store = new JdbmStore();
    private boolean optimizerEnabled = true;
    private Set<Index<?, ServerEntry>> indexedAttributes = new HashSet();

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setIndexedAttributes(Set<Index<?, ServerEntry>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public Set<Index<?, ServerEntry>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.store.setSyncOnWrite(syncOnWrite);
    }

    public boolean isSyncOnWrite() {
        return this.store.isSyncOnWrite();
    }

    @Override
    public void setRegistries(Registries registries) throws Exception {
        this.initRegistries(registries);
    }

    protected void initRegistries(Registries registries) throws Exception {
        this.registries = registries;
        this.store.initRegistries(registries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void init(DirectoryService directoryService) throws Exception {
        this.initRegistries(directoryService.getRegistries());
        EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.store, this.registries);
        CursorBuilder cursorBuilder = new CursorBuilder(this.store, evaluatorBuilder);
        this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer(this.store);
        this.searchEngine = new DefaultSearchEngine(this.store, cursorBuilder, evaluatorBuilder, this.optimizer);
        this.store.setCacheSize(this.cacheSize);
        this.store.setName(this.id);
        this.store.setSuffixDn(this.suffix);
        this.store.setWorkingDirectory(new File(directoryService.getWorkingDirectory().getPath() + File.separator + this.id));
        HashSet<JdbmIndex> userIndices = new HashSet<JdbmIndex>();
        for (Index<?, ServerEntry> obj : this.indexedAttributes) {
            JdbmIndex index;
            if (obj instanceof JdbmIndex) {
                index = (JdbmIndex)obj;
            } else {
                index = new JdbmIndex();
                index.setAttributeId(obj.getAttributeId());
                index.setCacheSize(obj.getCacheSize());
                index.setWkDirPath(obj.getWkDirPath());
            }
            String oid = this.registries.getOidRegistry().getOid(index.getAttributeId());
            if (SYS_INDEX_OIDS.contains(this.registries.getOidRegistry().getOid(index.getAttributeId()))) {
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                    this.store.setAliasIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                    this.store.setPresenceIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                    this.store.setOneLevelIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                    this.store.setNdnIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                    this.store.setOneAliasIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                    this.store.setSubAliasIndex((Index)index);
                } else {
                    if (!oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) throw new IllegalStateException("Unrecognized system index " + oid);
                    this.store.setUpdnIndex((Index)index);
                }
            } else {
                userIndices.add(index);
            }
            this.store.setUserIndices(userIndices);
        }
        this.store.init(this.registries);
    }

    @Override
    public final void destroy() throws Exception {
        this.store.destroy();
    }

    @Override
    public final boolean isInitialized() {
        return this.store.isInitialized();
    }

    @Override
    public final void sync() throws Exception {
        this.store.sync();
    }

    @Override
    public final void addIndexOn(Index<Long, ServerEntry> index) throws Exception {
        this.store.addIndex(index);
    }

    public final Index<String, ServerEntry> getExistanceIndex() {
        return this.store.getPresenceIndex();
    }

    @Override
    public final void setPresenceIndexOn(Index<String, ServerEntry> index) throws Exception {
        this.store.setPresenceIndex(index);
    }

    @Override
    public final Index<Long, ServerEntry> getOneLevelIndex() {
        return this.store.getOneLevelIndex();
    }

    @Override
    public final void setOneLevelIndexOn(Index<Long, ServerEntry> index) throws Exception {
        this.store.setOneLevelIndex(index);
    }

    @Override
    public final Index<String, ServerEntry> getAliasIndex() {
        return this.store.getAliasIndex();
    }

    @Override
    public final void setAliasIndexOn(Index<String, ServerEntry> index) throws Exception {
        this.store.setAliasIndex(index);
    }

    @Override
    public final Index<Long, ServerEntry> getOneAliasIndex() {
        return this.store.getOneAliasIndex();
    }

    @Override
    public final void setOneAliasIndexOn(Index<Long, ServerEntry> index) throws NamingException {
        this.store.setOneAliasIndex(index);
    }

    @Override
    public final Index<Long, ServerEntry> getSubAliasIndex() {
        return this.store.getSubAliasIndex();
    }

    @Override
    public final void setSubAliasIndexOn(Index<Long, ServerEntry> index) throws NamingException {
        this.store.setSubAliasIndex(index);
    }

    @Override
    public final Index<String, ServerEntry> getUpdnIndex() {
        return this.store.getUpdnIndex();
    }

    @Override
    public final void setUpdnIndexOn(Index<String, ServerEntry> index) throws NamingException {
        this.store.setUpdnIndex(index);
    }

    @Override
    public final Index<String, ServerEntry> getNdnIndex() {
        return this.store.getNdnIndex();
    }

    @Override
    public final void setNdnIndexOn(Index<String, ServerEntry> index) throws NamingException {
        this.store.setNdnIndex(index);
    }

    @Override
    public final Iterator<String> getUserIndices() {
        return this.store.userIndices();
    }

    @Override
    public final Iterator<String> getSystemIndices() {
        return this.store.systemIndices();
    }

    @Override
    public final boolean hasUserIndexOn(String id) throws NamingException {
        return this.store.hasUserIndexOn(id);
    }

    @Override
    public final boolean hasSystemIndexOn(String id) throws NamingException {
        return this.store.hasSystemIndexOn(id);
    }

    @Override
    public final Index<?, ServerEntry> getUserIndex(String id) throws IndexNotFoundException {
        return this.store.getUserIndex(id);
    }

    @Override
    public final Index<?, ServerEntry> getSystemIndex(String id) throws IndexNotFoundException {
        return this.store.getSystemIndex(id);
    }

    @Override
    public final Long getEntryId(String dn) throws Exception {
        return this.store.getEntryId(dn);
    }

    @Override
    public final String getEntryDn(Long id) throws Exception {
        return this.store.getEntryDn(id);
    }

    @Override
    public final Long getParentId(String dn) throws Exception {
        return this.store.getParentId(dn);
    }

    @Override
    public final Long getParentId(Long childId) throws Exception {
        return this.store.getParentId(childId);
    }

    @Override
    public final String getEntryUpdn(Long id) throws Exception {
        return this.store.getEntryUpdn(id);
    }

    @Override
    public final String getEntryUpdn(String dn) throws Exception {
        return this.store.getEntryUpdn(dn);
    }

    @Override
    public final int count() throws Exception {
        return this.store.count();
    }

    @Override
    public final void add(AddOperationContext addContext) throws Exception {
        this.store.add(addContext.getDn(), (ServerEntry)addContext.getEntry().getClonedEntry());
    }

    @Override
    public final ClonedServerEntry lookup(Long id) throws Exception {
        return new ClonedServerEntry(this.store.lookup(id));
    }

    @Override
    public final void delete(Long id) throws Exception {
        this.store.delete(id);
    }

    @Override
    public final IndexCursor<Long, ServerEntry> list(Long id) throws Exception {
        return this.store.list(id);
    }

    @Override
    public final int getChildCount(Long id) throws Exception {
        return this.store.getChildCount(id);
    }

    @Override
    public final LdapDN getSuffixDn() {
        return this.store.getSuffix();
    }

    @Override
    public final LdapDN getUpSuffixDn() {
        return this.store.getUpSuffix();
    }

    @Override
    public final void setProperty(String propertyName, String propertyValue) throws Exception {
        this.store.setProperty(propertyName, propertyValue);
    }

    @Override
    public final String getProperty(String propertyName) throws Exception {
        return this.store.getProperty(propertyName);
    }

    @Override
    public final void modify(ModifyOperationContext modifyContext) throws Exception {
        this.store.modify(modifyContext.getDn(), modifyContext.getModItems());
    }

    @Override
    public final void rename(RenameOperationContext renameContext) throws Exception {
        this.store.rename(renameContext.getDn(), renameContext.getNewRdn(), renameContext.getDelOldDn());
    }

    @Override
    public final void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws Exception {
        this.store.move(moveAndRenameContext.getDn(), moveAndRenameContext.getParent(), moveAndRenameContext.getNewRdn(), moveAndRenameContext.getDelOldDn());
    }

    @Override
    public final void move(MoveOperationContext moveContext) throws Exception {
        this.store.move(moveContext.getDn(), moveContext.getParent());
    }

    public final void bind(LdapDN bindDn, byte[] credentials, List<String> mechanisms, String saslAuthId) throws Exception {
        if (bindDn == null || credentials == null || mechanisms == null || saslAuthId == null) {
            // empty if block
        }
        throw new LdapAuthenticationNotSupportedException("Bind requests only tunnel down into partitions if there are no authenticators to handle the mechanism.\nCheck to see if you have correctly configured authenticators for the server.", ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
    }

    @Override
    public final void bind(BindOperationContext bindContext) throws Exception {
        throw new LdapAuthenticationNotSupportedException("Bind requests only tunnel down into partitions if there are no authenticators to handle the mechanism.\nCheck to see if you have correctly configured authenticators for the server.", ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
    }

    @Override
    public final void unbind(UnbindOperationContext unbindContext) throws Exception {
    }

    @Override
    public Index<String, ServerEntry> getPresenceIndex() {
        return this.store.getPresenceIndex();
    }

    @Override
    public Index<Long, ServerEntry> getSubLevelIndex() {
        return this.store.getSubLevelIndex();
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }
}

