/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.NameForm;

public class DitStructureRuleImpl
extends AbstractSchemaObject
implements DITStructureRule,
MutableSchemaObject {
    private static final long serialVersionUID = 1L;
    private final Integer[] EMPTY_INT_ARRAY = new Integer[0];
    private final DITStructureRule[] EMPTY_DSR_ARRAY = new DITStructureRule[0];
    private final Registries registries;
    private String nameFormOid;
    private Integer[] superClassRuleIds;
    private DITStructureRule[] superClasses;

    public DitStructureRuleImpl(String nameFormOid, Integer ruleId, Registries registries) {
        super(nameFormOid + "." + ruleId.toString());
        this.nameFormOid = nameFormOid;
        this.registries = registries;
    }

    public NameForm getNameForm() throws NamingException {
        return this.registries.getNameFormRegistry().lookup(this.nameFormOid);
    }

    public DITStructureRule[] getSuperClasses() throws NamingException {
        if (this.superClassRuleIds == null) {
            return this.EMPTY_DSR_ARRAY;
        }
        for (int ii = 0; ii < this.superClassRuleIds.length; ++ii) {
            this.superClasses[ii] = this.registries.getDitStructureRuleRegistry().lookup(this.superClassRuleIds[ii]);
        }
        return this.superClasses;
    }

    public void setSuperClassRuleIds(Integer[] superClassRuleIds) {
        if (superClassRuleIds == null) {
            this.superClassRuleIds = this.EMPTY_INT_ARRAY;
            this.superClasses = this.EMPTY_DSR_ARRAY;
        } else {
            this.superClassRuleIds = superClassRuleIds;
            this.superClasses = new DITStructureRule[superClassRuleIds.length];
        }
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setSchema(String schema) {
        super.setSchema(schema);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public Integer getRuleId() {
        return null;
    }
}

