/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.EmptyCursor;
import org.apache.directory.server.core.cursor.SingletonCursor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaChecker;
import org.apache.directory.server.core.schema.SchemaOperationControl;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.syntax.AcceptAllSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(SchemaInterceptor.class);
    private static final String[] SCHEMA_SUBENTRY_RETURN_ATTRIBUTES = new String[]{"+", "*"};
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PartitionNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private TopFilter topFilter;
    private List<EntryFilter> filters = new ArrayList<EntryFilter>();
    private Registries registries;
    private AttributeType OBJECT_CLASS;
    private AttributeTypeRegistry atRegistry;
    private String subschemaSubentryDnNorm;
    private LdapDN schemaModificationAttributesDN;
    private SchemaOperationControl schemaManager;
    private SchemaService schemaService;
    private LdapDN schemaBaseDN;
    private Map<String, List<ObjectClass>> superiors;
    private Map<String, List<AttributeType>> allMay;
    private Map<String, List<AttributeType>> allMust;
    private Map<String, List<AttributeType>> allowed;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Initializing SchemaInterceptor...");
        }
        this.nexus = directoryService.getPartitionNexus();
        this.registries = directoryService.getRegistries();
        this.atRegistry = this.registries.getAttributeTypeRegistry();
        this.OBJECT_CLASS = this.atRegistry.lookup("objectClass");
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        this.topFilter = new TopFilter();
        this.filters.add(this.binaryAttributeFilter);
        this.filters.add(this.topFilter);
        this.schemaBaseDN = new LdapDN("ou=schema");
        this.schemaBaseDN.normalize(this.atRegistry.getNormalizerMapping());
        this.schemaService = directoryService.getSchemaService();
        this.schemaManager = directoryService.getSchemaService().getSchemaControl();
        Value subschemaSubentry = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        LdapDN subschemaSubentryDn = new LdapDN((String)subschemaSubentry.get());
        subschemaSubentryDn.normalize(this.atRegistry.getNormalizerMapping());
        this.subschemaSubentryDnNorm = subschemaSubentryDn.getNormName();
        this.schemaModificationAttributesDN = new LdapDN("cn=schemaModifications,ou=schema");
        this.schemaModificationAttributesDN.normalize(this.atRegistry.getNormalizerMapping());
        this.computeSuperiors();
        if (IS_DEBUG) {
            LOG.debug("SchemaInterceptor Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set<String> atSeen) throws Exception {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        for (ObjectClass parent : parents) {
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set<String> atSeen) throws Exception {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List<AttributeType> allowedList = this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        for (ObjectClass parent : parents) {
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List<ObjectClass> superiors, Set<String> ocSeen) throws Exception {
        ObjectClass[] parents = objectClass.getSuperClasses();
        if (parents != null && parents.length != 0) {
            for (ObjectClass parent : parents) {
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parent.getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperiors() throws Exception {
        Iterator objectClasses = this.registries.getObjectClassRegistry().iterator();
        this.superiors = new HashMap<String, List<ObjectClass>>();
        this.allMust = new HashMap<String, List<AttributeType>>();
        this.allMay = new HashMap<String, List<AttributeType>>();
        this.allowed = new HashMap<String, List<AttributeType>>();
        while (objectClasses.hasNext()) {
            ArrayList<ObjectClass> ocSuperiors = new ArrayList<ObjectClass>();
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.superiors.put(objectClass.getOid(), ocSuperiors);
            this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet<String>());
            HashSet<String> atSeen = new HashSet<String>();
            this.computeMustAttributes(objectClass, atSeen);
            this.computeMayAttributes(objectClass, atSeen);
            this.superiors.put(objectClass.getName(), ocSuperiors);
        }
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        cursor.addEntryFilter(this.binaryAttributeFilter);
        return cursor;
    }

    private void filterAttributesToReturn(SearchControls searchCtls) {
        String[] attributes = searchCtls.getReturningAttributes();
        if (attributes == null || attributes.length == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            return;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        boolean hasNoAttribute = false;
        boolean hasAttributes = false;
        for (String attribute : attributes) {
            if ("*".equals(attribute) || "+".equals(attribute) || "1.1".equals(attribute)) {
                if (!filteredAttrs.containsKey(attribute)) {
                    filteredAttrs.put(attribute, attribute);
                }
                if ("1.1".equals(attribute)) {
                    hasNoAttribute = true;
                    continue;
                }
                hasAttributes = true;
                continue;
            }
            try {
                String oid;
                if (this.registries.getOidRegistry().hasOid(attribute) && this.atRegistry.hasAttributeType(oid = this.registries.getOidRegistry().getOid(attribute)) && !filteredAttrs.containsKey(oid)) {
                    filteredAttrs.put(oid, attribute);
                }
                hasAttributes = true;
            }
            catch (Exception ne) {
                // empty catch block
            }
        }
        if (hasAttributes && hasNoAttribute) {
            filteredAttrs.remove("1.1");
        }
        if (filteredAttrs.size() == attributes.length) {
            return;
        }
        if (filteredAttrs.size() == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return;
        }
        String[] newAttributesList = new String[filteredAttrs.size()];
        int pos = 0;
        for (String key : filteredAttrs.keySet()) {
            newAttributesList[pos++] = (String)filteredAttrs.get(key);
        }
        searchCtls.setReturningAttributes(newAttributesList);
    }

    private Value<?> convert(String id, Object value) throws Exception {
        AttributeType at = this.atRegistry.lookup(id);
        if (at.getSyntax().isHumanReadable()) {
            if (value instanceof byte[]) {
                try {
                    return new ClientStringValue(new String((byte[])value, "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    String message = "The value stored in an Human Readable attribute as a byte[] should be convertible to a String";
                    LOG.error(message);
                    throw new NamingException(message);
                }
            }
        } else if (value instanceof String) {
            try {
                return new ClientBinaryValue(((String)value).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                String message = "The value stored in a non Human Readable attribute as a String should be convertible to a byte[]";
                LOG.error(message);
                throw new NamingException(message);
            }
        }
        return null;
    }

    private void checkFilter(ExprNode filter) throws Exception {
        block20: {
            block18: {
                block21: {
                    block19: {
                        if (filter == null) {
                            String message = "A filter should not be null";
                            LOG.error(message);
                            throw new NamingException(message);
                        }
                        if (!filter.isLeaf()) break block18;
                        if (!(filter instanceof EqualityNode)) break block19;
                        EqualityNode node = (EqualityNode)filter;
                        Value value = node.getValue();
                        Value<?> newValue = this.convert(node.getAttribute(), value);
                        if (newValue != null) {
                            node.setValue(newValue);
                        }
                        break block20;
                    }
                    if (!(filter instanceof SubstringNode)) break block21;
                    SubstringNode node = (SubstringNode)filter;
                    if (!this.atRegistry.lookup(node.getAttribute()).getSyntax().isHumanReadable()) {
                        String message = "A Substring filter should be used only on Human Readable attributes";
                        LOG.error(message);
                        throw new NamingException(message);
                    }
                    break block20;
                }
                if (filter instanceof PresenceNode) break block20;
                if (filter instanceof GreaterEqNode) {
                    GreaterEqNode node = (GreaterEqNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else if (filter instanceof LessEqNode) {
                    LessEqNode node = (LessEqNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else if (filter instanceof ExtensibleNode) {
                    ExtensibleNode node = (ExtensibleNode)filter;
                    if (!this.atRegistry.lookup(node.getAttribute()).getSyntax().isHumanReadable()) {
                        String message = "A Extensible filter should be used only on Human Readable attributes";
                        LOG.error(message);
                        throw new NamingException(message);
                    }
                } else if (filter instanceof ApproximateNode) {
                    ApproximateNode node = (ApproximateNode)filter;
                    Value value = node.getValue();
                    Value<?> newValue = this.convert(node.getAttribute(), value);
                    if (newValue != null) {
                        node.setValue(newValue);
                    }
                } else {
                    if (filter instanceof AssertionNode) {
                        return;
                    }
                    if (filter instanceof ScopeNode) {
                        return;
                    }
                }
                break block20;
            }
            for (ExprNode child : ((BranchNode)filter).getChildren()) {
                this.checkFilter(child);
            }
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        String baseNormForm;
        LdapDN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        if (searchCtls.getReturningAttributes() != null) {
            this.filterAttributesToReturn(searchCtls);
        }
        this.checkFilter(filter);
        String string = baseNormForm = base.isNormalized() ? base.getNormName() : base.toNormName();
        if (!this.subschemaSubentryDnNorm.equals(baseNormForm)) {
            EntryFilteringCursor cursor = nextInterceptor.search(opContext);
            if (searchCtls.getReturningAttributes() != null) {
                cursor.addEntryFilter(this.topFilter);
                return cursor;
            }
            for (EntryFilter ef : this.filters) {
                cursor.addEntryFilter(ef);
            }
            return cursor;
        }
        if (searchCtls.getSearchScope() == 0) {
            PresenceNode node;
            if (filter instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)filter;
                String objectClass = node2.getValue() instanceof ClientStringValue ? (String)node2.getValue().get() : node2.getValue().get().toString();
                String objectClassOid = null;
                if (!this.registries.getObjectClassRegistry().hasObjectClass(objectClass)) {
                    return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new EmptyCursor(), opContext);
                }
                objectClassOid = this.registries.getObjectClassRegistry().lookup(objectClass).getOid();
                String nodeOid = this.registries.getOidRegistry().getOid(node2.getAttribute());
                if (nodeOid.equals("2.5.4.0") && (objectClassOid.equals("2.5.6.0") || objectClassOid.equals("2.5.20.1")) && node2 instanceof EqualityNode) {
                    ServerEntry serverEntry = this.schemaService.getSubschemaEntry(searchCtls.getReturningAttributes());
                    serverEntry.setDn(base);
                    return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new SingletonCursor((Object)serverEntry), opContext);
                }
                return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new EmptyCursor(), opContext);
            }
            if (filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttribute().equals("2.5.4.0")) {
                ServerEntry serverEntry = this.schemaService.getSubschemaEntry(searchCtls.getReturningAttributes());
                serverEntry.setDn(base);
                BaseEntryFilteringCursor cursor = new BaseEntryFilteringCursor((Cursor<ServerEntry>)new SingletonCursor((Object)serverEntry), opContext);
                return cursor;
            }
        }
        return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new EmptyCursor(), opContext);
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        this.filterBinaryAttributes((ServerEntry)result);
        this.filterObjectClass((ServerEntry)result);
        return result;
    }

    private void getSuperiors(ObjectClass oc, Set<String> ocSeen, List<ObjectClass> result) throws Exception {
        for (ObjectClass parent : oc.getSuperClasses()) {
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean isRequired(String attrId, EntryAttribute objectClasses) throws Exception {
        OidRegistry oidRegistry = this.registries.getOidRegistry();
        ObjectClassRegistry registry = this.registries.getObjectClassRegistry();
        if (!oidRegistry.hasOid(attrId)) {
            return false;
        }
        String attrOid = oidRegistry.getOid(attrId);
        for (Value objectClass : objectClasses) {
            ObjectClass ocSpec = registry.lookup((String)objectClass.get());
            for (AttributeType must : ocSpec.getMustList()) {
                if (!must.getOid().equals(attrOid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompleteRemoval(ServerAttribute change, ServerEntry entry) throws Exception {
        if (change.size() == 0) {
            return true;
        }
        ServerAttribute changedEntryAttr = (ServerAttribute)entry.get(change.getUpId()).clone();
        for (Value value : change) {
            changedEntryAttr.remove(new Value[]{value});
        }
        return changedEntryAttr.size() == 0;
    }

    private EntryAttribute getResultantObjectClasses(ModificationOperation modOp, EntryAttribute changes, EntryAttribute existing) throws Exception {
        if (changes == null && existing == null) {
            return new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        if (changes == null) {
            return existing;
        }
        if (existing == null && modOp == ModificationOperation.ADD_ATTRIBUTE) {
            return changes;
        }
        if (existing == null) {
            return new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                for (Value value : changes) {
                    existing.add(new Value[]{value});
                }
                return existing;
            }
            case REPLACE_ATTRIBUTE: {
                return (ServerAttribute)changes.clone();
            }
            case REMOVE_ATTRIBUTE: {
                for (Value value : changes) {
                    existing.remove(new Value[]{value});
                }
                return existing;
            }
        }
        throw new InternalError("");
    }

    private boolean getObjectClasses(EntryAttribute objectClasses, List<ObjectClass> result) throws Exception {
        HashSet<String> ocSeen = new HashSet<String>();
        ObjectClassRegistry registry = this.registries.getObjectClassRegistry();
        boolean hasExtensibleObject = false;
        for (Value objectClass : objectClasses) {
            ObjectClass oc;
            String objectClassName = (String)objectClass.get();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = registry.lookup(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set<String> getAllMust(EntryAttribute objectClasses) throws Exception {
        HashSet<String> must = new HashSet<String>();
        for (Value value : objectClasses) {
            String ocName = (String)value.get();
            ObjectClass oc = this.registries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMustList();
            if (types == null || types.length <= 0) continue;
            for (AttributeType type : types) {
                must.add(type.getOid());
            }
        }
        return must;
    }

    private Set<String> getAllAllowed(EntryAttribute objectClasses, Set<String> must) throws Exception {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add(this.registries.getOidRegistry().getOid("objectClass"));
        for (Value objectClass : objectClasses) {
            String ocName = (String)objectClass.get();
            ObjectClass oc = this.registries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMayList();
            if (types == null || types.length <= 0) continue;
            for (AttributeType type : types) {
                String oid = type.getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(EntryAttribute objectClassAttr) throws Exception {
        HashSet<String> objectClasses = new HashSet<String>();
        HashSet<String> objectClassesUP = new HashSet<String>();
        objectClasses.add("top");
        objectClassesUP.add("top");
        for (Value ocValue : objectClassAttr) {
            List<ObjectClass> ocSuperiors;
            String ocName = (String)ocValue.get();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = ocName.toLowerCase();
            ObjectClass objectClass = this.registries.getObjectClassRegistry().lookup(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
                objectClassesUP.add(ocName);
            }
            if ((ocSuperiors = this.superiors.get(objectClass.getOid())) == null) continue;
            for (ObjectClass oc : ocSuperiors) {
                if (objectClasses.contains(oc.getName().toLowerCase())) continue;
                objectClasses.add(oc.getName());
                objectClassesUP.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        for (String attribute : objectClassesUP) {
            objectClassAttr.add(new String[]{attribute});
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        if (oriChildName.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.move(opContext, (ServerEntry)entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.moveAndRename(opContext);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        if (oriChildName.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.replace(opContext, (ServerEntry)entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.move(opContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        Rdn newRdn = opContext.getNewRdn();
        boolean deleteOldRn = opContext.getDelOldDn();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        if (deleteOldRn) {
            String value;
            AttributeType type;
            ServerEntry tmpEntry = (ServerEntry)entry.clone();
            Rdn oldRDN = name.getRdn();
            for (AttributeTypeAndValue atav : oldRDN) {
                type = this.atRegistry.lookup(atav.getUpType());
                value = (String)atav.getNormValue();
                tmpEntry.remove(type, new String[]{value});
            }
            for (AttributeTypeAndValue atav : newRdn) {
                type = this.atRegistry.lookup(atav.getUpType());
                value = (String)atav.getNormValue();
                if (tmpEntry.contains(type, new String[]{value})) continue;
                tmpEntry.add(new EntryAttribute[]{new DefaultServerAttribute(type, new String[]{value})});
            }
            LdapDN newDn = (LdapDN)name.clone();
            newDn.remove(name.size() - 1);
            newDn.add(newRdn);
            tmpEntry.setDn(newDn);
            this.check(name, tmpEntry);
            for (AttributeTypeAndValue atav : oldRDN) {
                AttributeType attributeType = this.atRegistry.lookup(atav.getUpType());
                if (attributeType.isCanUserModify()) continue;
                throw new NoPermissionException("Cannot modify the attribute '" + atav.getUpType() + "'");
            }
        }
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.modifyRn(opContext, (ServerEntry)entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.rename(opContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        EntryAttribute objectClass;
        ServerEntry entry;
        LdapDN name = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        if (name.getNormName().equalsIgnoreCase(this.subschemaSubentryDnNorm)) {
            entry = this.schemaService.getSubschemaEntry(SCHEMA_SUBENTRY_RETURN_ATTRIBUTES);
            entry.setDn(name);
        } else {
            entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        }
        ServerEntry targetEntry = (ServerEntry)SchemaUtils.getTargetEntry(mods, (Entry)entry);
        if (entry == null) {
            LOG.error("No entry with this name :{}", (Object)name);
            throw new LdapNameNotFoundException("The entry which name is " + name + " is not found.");
        }
        ServerEntry tmpEntry = (ServerEntry)entry.clone();
        HashSet<String> modset = new HashSet<String>();
        Modification objectClassMod = null;
        for (Modification mod : mods) {
            if (mod.getAttribute().getId().equalsIgnoreCase("objectClass")) {
                objectClassMod = mod;
            }
            if (mod.getAttribute().size() == 0 && mod.getOperation() == ModificationOperation.ADD_ATTRIBUTE) {
                throw new LdapInvalidAttributeValueException("No value is not a valid value for an attribute.", ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            }
            StringBuffer keybuf = new StringBuffer();
            keybuf.append(mod.getOperation());
            keybuf.append(mod.getAttribute().getId());
            for (Value value : (ServerAttribute)mod.getAttribute()) {
                keybuf.append(value.get());
            }
            if (modset.add(keybuf.toString()) || mod.getOperation() != ModificationOperation.ADD_ATTRIBUTE) continue;
            throw new LdapAttributeInUseException("found two copies of the following modification item: " + mod);
        }
        if (objectClassMod == null) {
            objectClass = entry.get("objectClass");
            if (objectClass == null) {
                objectClass = new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
            }
        } else {
            objectClass = this.getResultantObjectClasses(objectClassMod.getOperation(), objectClassMod.getAttribute(), tmpEntry.get("objectClass"));
        }
        ObjectClassRegistry ocRegistry = this.registries.getObjectClassRegistry();
        block12: for (Modification mod : mods) {
            ModificationOperation modOp = mod.getOperation();
            ServerAttribute change = (ServerAttribute)mod.getAttribute();
            if (change.getAttributeType() == null && !this.atRegistry.hasAttributeType(change.getUpId()) && !objectClass.contains(new String[]{"extensibleObject"})) {
                throw new LdapInvalidAttributeIdentifierException();
            }
            AttributeType attributeType = change.getAttributeType();
            if (attributeType == null) {
                attributeType = this.atRegistry.lookup(change.getUpId());
            }
            if (!attributeType.isCanUserModify()) {
                throw new NoPermissionException("Cannot modify the attribute '" + change.getUpId() + "'");
            }
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    EntryAttribute attr = tmpEntry.get(attributeType.getName());
                    if (attr != null) {
                        for (Value value : change) {
                            attr.add(new Value[]{value});
                        }
                        continue block12;
                    }
                    attr = new DefaultServerAttribute(change.getUpId(), attributeType);
                    for (Value value : change) {
                        attr.add(new Value[]{value});
                    }
                    tmpEntry.put(new EntryAttribute[]{attr});
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    if (tmpEntry.get(change.getId()) == null) {
                        LOG.error("Trying to remove an non-existant attribute: " + change.getUpId());
                        throw new LdapNoSuchAttributeException();
                    }
                    if (change.size() == 0) {
                        if (this.isRequired(change.getUpId(), objectClass)) {
                            LOG.error("Trying to remove a required attribute: " + change.getUpId());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                    } else {
                        if (this.isRequired(change.getUpId(), objectClass) && this.isCompleteRemoval(change, entry)) {
                            LOG.error("Trying to remove a required attribute: " + change.getUpId());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                        EntryAttribute modified = (EntryAttribute)tmpEntry.removeAttributes(new String[]{change.getId()}).get(0);
                        for (Value value : change) {
                            modified.remove(new Value[]{value});
                        }
                        if (modified.size() == 0 && this.isRequired(change.getId(), objectClass)) {
                            LOG.error("Trying to remove a required attribute: " + change.getUpId());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                        if (modified.size() > 0) {
                            tmpEntry.put(new EntryAttribute[]{modified});
                        }
                    }
                    SchemaChecker.preventRdnChangeOnModifyRemove(name, modOp, change, this.registries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyRemove(ocRegistry, name, modOp, (EntryAttribute)change, objectClass);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    SchemaChecker.preventRdnChangeOnModifyReplace(name, modOp, change, this.registries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyReplace(ocRegistry, name, modOp, change);
                    EntryAttribute attr = tmpEntry.get(change.getUpId());
                    if (attr != null) {
                        tmpEntry.removeAttributes(new String[]{change.getUpId()});
                    }
                    attr = new DefaultServerAttribute(change.getUpId(), attributeType);
                    if (change.size() == 0) break;
                    for (Value value : change) {
                        attr.add(new Value[]{value});
                    }
                    tmpEntry.put(new EntryAttribute[]{attr});
                }
            }
        }
        this.check(name, tmpEntry);
        if (objectClassMod != null) {
            ServerAttribute alteredObjectClass = (ServerAttribute)objectClass.clone();
            this.alterObjectClasses((EntryAttribute)alteredObjectClass);
            if (!alteredObjectClass.equals(objectClass)) {
                ServerAttribute ocMods = (ServerAttribute)objectClassMod.getAttribute();
                switch (objectClassMod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        if (ocMods.contains(new String[]{"top"})) {
                            ocMods.remove(new String[]{"top"});
                        }
                        for (Value value : alteredObjectClass) {
                            if (objectClass.contains(new Value[]{value})) continue;
                            ocMods.add(new Value[]{value});
                        }
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        for (Value value : alteredObjectClass) {
                            if (objectClass.contains(new Value[]{value})) continue;
                            ocMods.remove(new Value[]{value});
                        }
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        for (Value value : alteredObjectClass) {
                            if (objectClass.contains(new Value[]{value})) continue;
                            ocMods.add(new Value[]{value});
                        }
                        break;
                    }
                }
            }
        }
        if (name.startsWith((Name)this.schemaBaseDN)) {
            LOG.debug("Modification attempt on schema partition {}: \n{}", (Object)name, (Object)opContext);
            this.schemaManager.modify(opContext, entry, targetEntry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        } else if (this.subschemaSubentryDnNorm.equals(name.getNormName())) {
            LOG.debug("Modification attempt on schema subentry {}: \n{}", (Object)name, (Object)opContext);
            this.schemaManager.modifySchemaSubentry(opContext, entry, targetEntry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
            return;
        }
        next.modify(opContext);
    }

    private void filterAttributeTypes(SearchingOperationContext operation, ClonedServerEntry result) {
        if (operation.getReturningAttributes() == null) {
            return;
        }
        block2: for (AttributeTypeOptions attrOptions : operation.getReturningAttributes()) {
            EntryAttribute attribute = result.get(attrOptions.getAttributeType());
            if (!attrOptions.hasOption()) continue;
            for (String option : attrOptions.getOptions()) {
                if ("binary".equalsIgnoreCase(option)) continue;
                try {
                    if (!result.contains(new EntryAttribute[]{attribute})) continue block2;
                    result.remove(new EntryAttribute[]{attribute});
                }
                catch (NamingException ne) {}
                continue block2;
            }
        }
    }

    private void filterObjectClass(ServerEntry entry) throws Exception {
        ArrayList<ObjectClass> objectClasses = new ArrayList<ObjectClass>();
        EntryAttribute oc = entry.get("objectClass");
        if (oc != null) {
            this.getObjectClasses(oc, objectClasses);
            entry.removeAttributes(new String[]{"objectClass"});
            DefaultServerAttribute newOc = new DefaultServerAttribute(((ServerAttribute)oc).getAttributeType());
            for (ObjectClass currentOC : objectClasses) {
                newOc.add(new String[]{currentOC.getName()});
            }
            newOc.add(new String[]{"top"});
            entry.put(new EntryAttribute[]{newOc});
        }
    }

    private void filterBinaryAttributes(ServerEntry entry) throws Exception {
        for (EntryAttribute attribute : entry) {
            if (((ServerAttribute)attribute).getAttributeType().getSyntax().isHumanReadable()) continue;
            ArrayList<ServerBinaryValue> binaries = new ArrayList<ServerBinaryValue>();
            for (Value value : attribute) {
                Object attrValue = value.get();
                if (attrValue instanceof String) {
                    binaries.add(new ServerBinaryValue(((ServerAttribute)attribute).getAttributeType(), StringTools.getBytesUtf8((String)((String)attrValue))));
                    continue;
                }
                binaries.add(new ServerBinaryValue(((ServerAttribute)attribute).getAttributeType(), (byte[])attrValue));
            }
            attribute.clear();
            attribute.put(binaries);
        }
    }

    private void check(LdapDN dn, ServerEntry entry) throws Exception {
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            if (this.atRegistry.hasAttributeType(attributeType.getName())) continue;
            throw new LdapInvalidAttributeIdentifierException(attributeType.getName() + " not found in attribute registry!");
        }
        EntryAttribute objectClassAttr = entry.get("objectClass");
        if (objectClassAttr == null) {
            objectClassAttr = new DefaultServerAttribute("objectClass", this.OBJECT_CLASS);
        }
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        this.alterObjectClasses(objectClassAttr);
        Set<String> must = this.getAllMust(objectClassAttr);
        Set<String> allowed = this.getAllAllowed(objectClassAttr, must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertObjectClasses(dn, ocs);
        this.assertRequiredAttributesPresent(dn, (Entry)entry, must);
        this.assertNumberOfAttributeValuesValid((Entry)entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadable(entry);
        this.assertSyntaxes((Entry)entry);
        Rdn rdn = entry.getDn().getRdn();
        for (AttributeTypeAndValue ava : rdn) {
            String value = (String)ava.getNormValue();
            String upValue = (String)ava.getUpValue();
            String upId = ava.getUpType();
            if (entry.contains(upId, new String[]{value})) continue;
            String message = "The RDN '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(new String[]{upId})) {
                entry.add(upId, new String[]{upValue});
                continue;
            }
            AttributeType at = this.atRegistry.lookup(upId);
            if (at.isSingleValue()) {
                entry.removeAttributes(new String[]{upId});
                entry.put(upId, new String[]{upValue});
                continue;
            }
            entry.add(upId, new String[]{upValue});
        }
    }

    private void checkOcSuperior(ServerEntry entry) throws Exception {
        ObjectClassRegistry ocRegistry = this.registries.getObjectClassRegistry();
        EntryAttribute supOC = entry.get("m-supObjectClass");
        if (supOC != null) {
            ObjectClassTypeEnum ocType = ObjectClassTypeEnum.STRUCTURAL;
            if (entry.get("m-typeObjectClass") != null) {
                String type = entry.get("m-typeObjectClass").getString();
                ocType = ObjectClassTypeEnum.getClassType((String)type);
            }
            for (Value sup : supOC) {
                try {
                    String supName = (String)sup.get();
                    ObjectClass superior = ocRegistry.lookup(supName);
                    switch (ocType) {
                        case ABSTRACT: {
                            if (superior.isAbstract()) break;
                            String message = "An ABSTRACT ObjectClass cannot inherit from an objectClass which is not ABSTRACT";
                            LOG.error(message);
                            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                        case AUXILIARY: {
                            if (superior.isAbstract() || superior.isAuxiliary()) break;
                            String message = "An AUXILiARY ObjectClass cannot inherit from an objectClass which is not ABSTRACT or AUXILIARY";
                            LOG.error(message);
                            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                    }
                }
                catch (NamingException ne) {
                    String message = "Cannot have a superior which does not exist";
                    LOG.error(message);
                    throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                }
            }
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapDN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        this.check(name, (ServerEntry)entry);
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.add(addContext);
            this.checkOcSuperior((ServerEntry)addContext.getEntry());
        }
        next.add(addContext);
    }

    private void assertAllAttributesAllowed(LdapDN dn, ServerEntry entry, Set<String> allowed) throws Exception {
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass.contains(new String[]{"extensibleObject"})) {
            return;
        }
        for (EntryAttribute attribute : entry) {
            String attrOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            AttributeType attributeType = ((ServerAttribute)attribute).getAttributeType();
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USER_APPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException("Attribute " + attribute.getUpId() + " not declared in objectClasses of entry " + dn.getUpName(), ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        if (name.startsWith((Name)this.schemaBaseDN)) {
            ClonedServerEntry entry = this.nexus.lookup(opContext.newLookupContext(name));
            this.schemaManager.delete(opContext, entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.delete(opContext);
    }

    private void assertNumberOfAttributeValuesValid(Entry entry) throws InvalidAttributeValueException, Exception {
        for (EntryAttribute attribute : entry) {
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(EntryAttribute attribute) throws InvalidAttributeValueException, Exception {
        if (attribute.size() > 1 && ((ServerAttribute)attribute).getAttributeType().isSingleValue()) {
            throw new LdapInvalidAttributeValueException("More than one value has been provided for the single-valued attribute: " + attribute.getUpId(), ResultCodeEnum.CONSTRAINT_VIOLATION);
        }
    }

    private void assertRequiredAttributesPresent(LdapDN dn, Entry entry, Set<String> must) throws Exception {
        for (EntryAttribute attribute : entry) {
            must.remove(((ServerAttribute)attribute).getAttributeType().getOid());
        }
        if (must.size() != 0) {
            throw new LdapSchemaViolationException("Required attributes " + must + " not found within entry " + dn.getUpName(), ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    private void assertObjectClasses(LdapDN dn, List<ObjectClass> ocs) throws Exception {
        HashSet<ObjectClass> structuralObjectClasses = new HashSet<ObjectClass>();
        for (ObjectClass oc : ocs) {
            if (!oc.isStructural()) continue;
            structuralObjectClasses.add(oc);
        }
        if (structuralObjectClasses.isEmpty()) {
            String message = "Entry " + dn + " does not contain a STRUCTURAL ObjectClass";
            LOG.error(message);
            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        HashSet<ObjectClass> remaining = new HashSet<ObjectClass>(structuralObjectClasses.size());
        remaining.addAll(structuralObjectClasses);
        for (ObjectClass oc : structuralObjectClasses) {
            if (oc.getSuperClasses() == null) continue;
            for (ObjectClass superClass : oc.getSuperClasses()) {
                if (!superClass.isStructural()) continue;
                remaining.remove(superClass);
            }
        }
        if (remaining.size() > 1) {
            String message = "Entry " + dn + " contains more than one STRUCTURAL ObjectClass: " + remaining;
            LOG.error(message);
            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    private void assertSyntaxes(Entry entry) throws Exception {
        for (EntryAttribute attribute : entry) {
            AttributeType attributeType = ((ServerAttribute)attribute).getAttributeType();
            SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
            if (syntaxChecker instanceof AcceptAllSyntaxChecker) continue;
            for (Value value : attribute) {
                try {
                    syntaxChecker.assertSyntax(value.get());
                }
                catch (Exception ne) {
                    String message = "Attribute value '" + (value instanceof ServerStringValue ? value.get() : StringTools.dumpBytes((byte[])((byte[])value.get()))) + "' for attribute '" + attribute.getUpId() + "' is syntactically incorrect";
                    LOG.info(message);
                    throw new LdapInvalidAttributeValueException(message, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                }
            }
        }
    }

    private boolean checkHumanReadable(EntryAttribute attribute) throws Exception {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof ServerStringValue) continue;
            if (value instanceof ServerBinaryValue) {
                try {
                    String valStr = new String((byte[])value.get(), "UTF-8");
                    attribute.remove(new Value[]{value});
                    attribute.add(new String[]{valStr});
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new NamingException("The value is not a valid String");
                }
            }
            throw new NamingException("The value stored in an Human Readable attribute is not a String");
        }
        return isModified;
    }

    private boolean checkNotHumanReadable(EntryAttribute attribute) throws Exception {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof ServerBinaryValue) continue;
            if (value instanceof ServerStringValue) {
                try {
                    byte[] valBytes = ((String)value.get()).getBytes("UTF-8");
                    attribute.remove(new Value[]{value});
                    attribute.add((byte[][])new byte[][]{valBytes});
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    String message = "The value stored in a not Human Readable attribute as a String should be convertible to a byte[]";
                    LOG.error(message);
                    throw new NamingException(message);
                }
            }
            String message = "The value is not valid. It should be a String or a byte[]";
            LOG.error(message);
            throw new NamingException(message);
        }
        return isModified;
    }

    private void assertHumanReadable(ServerEntry entry) throws Exception {
        boolean isModified = false;
        ServerEntry clonedEntry = null;
        for (EntryAttribute attribute : entry) {
            AttributeType attributeType = ((ServerAttribute)attribute).getAttributeType();
            isModified = attributeType.getSyntax().isHumanReadable() ? this.checkHumanReadable(attribute) : this.checkNotHumanReadable(attribute);
            if (!isModified) continue;
            if (clonedEntry == null) {
                clonedEntry = (ServerEntry)entry.clone();
            }
            clonedEntry.put(new EntryAttribute[]{attribute});
            isModified = false;
        }
        if (clonedEntry != null) {
            entry = clonedEntry;
        }
    }

    private class TopFilter
    implements EntryFilter {
        private TopFilter() {
        }

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
            SchemaInterceptor.this.filterObjectClass((ServerEntry)result);
            SchemaInterceptor.this.filterAttributeTypes(operation, result);
            return true;
        }
    }

    private class BinaryAttributeFilter
    implements EntryFilter {
        private BinaryAttributeFilter() {
        }

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
            SchemaInterceptor.this.filterBinaryAttributes((ServerEntry)result);
            return true;
        }
    }
}

