/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.schema.DescriptionParsers;
import org.apache.directory.server.core.schema.MetaAttributeTypeHandler;
import org.apache.directory.server.core.schema.MetaComparatorHandler;
import org.apache.directory.server.core.schema.MetaDitContentRuleHandler;
import org.apache.directory.server.core.schema.MetaDitStructureRuleHandler;
import org.apache.directory.server.core.schema.MetaMatchingRuleHandler;
import org.apache.directory.server.core.schema.MetaMatchingRuleUseHandler;
import org.apache.directory.server.core.schema.MetaNameFormHandler;
import org.apache.directory.server.core.schema.MetaNormalizerHandler;
import org.apache.directory.server.core.schema.MetaObjectClassHandler;
import org.apache.directory.server.core.schema.MetaSchemaHandler;
import org.apache.directory.server.core.schema.MetaSyntaxCheckerHandler;
import org.apache.directory.server.core.schema.MetaSyntaxHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SchemaSubentryModifier;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOperationControl {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOperationControl.class);
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private static final String[] OP_ATTRS = new String[]{"comparators", "normalizers", "syntaxCheckers", "ldapSyntaxes", "matchingRules", "attributeTypes", "objectClasses", "matchingRuleUse", "ditStructureRules", "ditContentRules", "nameForms"};
    private static final String[] META_OBJECT_CLASSES = new String[]{"metaComparator", "metaNormalizer", "metaSyntaxChecker", "metaSyntax", "metaMatchingRule", "metaAttributeType", "metaObjectClass", "metaMatchingRuleUse", "metaDITStructureRule", "metaDITContentRule", "metaNameForm"};
    private static final Collection<String> SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS;
    private final MetaSchemaHandler metaSchemaHandler;
    private final Registries registries;
    private final AttributeType objectClassAT;
    private final SchemaSubentryModifier subentryModifier;
    private final SchemaChangeHandler[] schemaObjectHandlers = new SchemaChangeHandler[11];
    private final DescriptionParsers parsers;
    private final Map<String, SchemaChangeHandler> opAttr2handlerMap = new HashMap<String, SchemaChangeHandler>();
    private final Map<String, SchemaChangeHandler> objectClass2handlerMap = new HashMap<String, SchemaChangeHandler>();
    private final Map<String, Integer> opAttr2handlerIndex = new HashMap<String, Integer>(11);
    private static final String CASCADING_ERROR = "Cascading has not yet been implemented: standard operation is in effect.";

    public SchemaOperationControl(Registries registries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws Exception {
        this.registries = registries;
        this.objectClassAT = this.registries.getAttributeTypeRegistry().lookup("objectClass");
        this.metaSchemaHandler = new MetaSchemaHandler(this.registries, loader);
        this.schemaObjectHandlers[0] = new MetaComparatorHandler(registries, loader);
        this.schemaObjectHandlers[1] = new MetaNormalizerHandler(registries, loader);
        this.schemaObjectHandlers[2] = new MetaSyntaxCheckerHandler(registries, loader);
        this.schemaObjectHandlers[3] = new MetaSyntaxHandler(registries, loader, dao);
        this.schemaObjectHandlers[4] = new MetaMatchingRuleHandler(registries, loader, dao);
        this.schemaObjectHandlers[5] = new MetaAttributeTypeHandler(registries, loader, dao);
        this.schemaObjectHandlers[6] = new MetaObjectClassHandler(registries, loader, dao);
        this.schemaObjectHandlers[7] = new MetaMatchingRuleUseHandler(registries, loader);
        this.schemaObjectHandlers[8] = new MetaDitStructureRuleHandler(registries, loader);
        this.schemaObjectHandlers[9] = new MetaDitContentRuleHandler(registries, loader);
        this.schemaObjectHandlers[10] = new MetaNameFormHandler(registries, loader);
        this.subentryModifier = new SchemaSubentryModifier(registries, dao);
        this.parsers = new DescriptionParsers(registries, dao);
        OidRegistry oidRegistry = registries.getOidRegistry();
        String comparatorsOid = oidRegistry.getOid("comparators");
        this.opAttr2handlerIndex.put(comparatorsOid, 0);
        String normalizersOid = oidRegistry.getOid("normalizers");
        this.opAttr2handlerIndex.put(normalizersOid, 1);
        String syntaxCheckersOid = oidRegistry.getOid("syntaxCheckers");
        this.opAttr2handlerIndex.put(syntaxCheckersOid, 2);
        String ldapSyntaxesOid = oidRegistry.getOid("ldapSyntaxes");
        this.opAttr2handlerIndex.put(ldapSyntaxesOid, 3);
        String matchingRulesOid = oidRegistry.getOid("matchingRules");
        this.opAttr2handlerIndex.put(matchingRulesOid, 4);
        String attributeTypesOid = oidRegistry.getOid("attributeTypes");
        this.opAttr2handlerIndex.put(attributeTypesOid, 5);
        String objectClassesOid = oidRegistry.getOid("objectClasses");
        this.opAttr2handlerIndex.put(objectClassesOid, 6);
        String matchingRuleUseOid = oidRegistry.getOid("matchingRuleUse");
        this.opAttr2handlerIndex.put(matchingRuleUseOid, 7);
        String ditStructureRulesOid = oidRegistry.getOid("ditStructureRules");
        this.opAttr2handlerIndex.put(ditStructureRulesOid, 8);
        String ditContentRulesOid = oidRegistry.getOid("ditContentRules");
        this.opAttr2handlerIndex.put(ditContentRulesOid, 9);
        String nameFormsOid = oidRegistry.getOid("nameForms");
        this.opAttr2handlerIndex.put(nameFormsOid, 10);
        this.initHandlerMaps();
    }

    private void initHandlerMaps() throws NamingException {
        AttributeTypeRegistry atReg = this.registries.getAttributeTypeRegistry();
        for (int ii = 0; ii < OP_ATTRS.length; ++ii) {
            AttributeType at = atReg.lookup(OP_ATTRS[ii]);
            this.opAttr2handlerMap.put(at.getOid(), this.schemaObjectHandlers[ii]);
        }
        ObjectClassRegistry ocReg = this.registries.getObjectClassRegistry();
        for (int ii = 0; ii < META_OBJECT_CLASSES.length; ++ii) {
            ObjectClass oc = ocReg.lookup(META_OBJECT_CLASSES[ii]);
            this.objectClass2handlerMap.put(oc.getOid(), this.schemaObjectHandlers[ii]);
        }
    }

    public Registries getGlobalRegistries() {
        return this.registries;
    }

    public Registries getRegistries(LdapDN dn) {
        LOG.error("Ignoring request for specific registries under dn {}", (Object)dn);
        throw new NotImplementedException();
    }

    public void add(AddOperationContext opContext) throws Exception {
        EntryAttribute oc = opContext.getEntry().get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.add(opContext.getDn(), (ServerEntry)opContext.getEntry());
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.add(opContext.getDn(), (ServerEntry)opContext.getEntry());
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"organizationalUnit"})) {
            if (opContext.getDn().size() != 3) {
                throw new LdapInvalidNameException("Schema entity containers of objectClass organizationalUnit should be 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
            }
            String ouValue = (String)opContext.getDn().getRdn().getValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                throw new LdapInvalidNameException("Expecting organizationalUnit with one of the following names: " + VALID_OU_VALUES, ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void delete(DeleteOperationContext opContext, ClonedServerEntry entry, boolean doCascadeDelete) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.delete(opContext.getDn(), (ServerEntry)entry, doCascadeDelete);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.delete(opContext.getDn(), (ServerEntry)entry, doCascadeDelete);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"organizationalUnit"})) {
            if (opContext.getDn().size() != 3) {
                throw new LdapNamingException("Only schema entity containers of objectClass organizationalUnit with 3 name components in length can be deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            String ouValue = (String)opContext.getDn().getRdn().getValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                throw new LdapInvalidNameException("Can only delete organizationalUnit entity containers with one of the following names: " + VALID_OU_VALUES, ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modify(ModifyOperationContext opContext, ModificationOperation modOp, ServerEntry mods, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.modify(opContext.getDn(), modOp, mods, entry, targetEntry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.modify(opContext.getDn(), modOp, mods, entry, targetEntry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modify(ModifyOperationContext opContext, ServerEntry entry, ServerEntry targetEntry, boolean doCascadeModify) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.modify(opContext.getDn(), opContext.getModItems(), entry, targetEntry, doCascadeModify);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.modify(opContext.getDn(), opContext.getModItems(), entry, targetEntry, doCascadeModify);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        LOG.error(String.format("Unwilling to perform modify on %s:\n\nEntry:\n%s\n\nModifications:\n%s", opContext.getDn(), entry, opContext.getModItems()));
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modifyRn(RenameOperationContext opContext, ServerEntry entry, boolean doCascadeModify) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.rename(opContext.getDn(), entry, opContext.getNewRdn(), doCascadeModify);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.rename(opContext.getDn(), entry, opContext.getNewRdn(), doCascadeModify);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void replace(MoveOperationContext opContext, ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.replace(opContext.getDn(), opContext.getParent(), entry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.replace(opContext.getDn(), opContext.getParent(), entry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void move(MoveAndRenameOperationContext opContext, ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getOidRegistry().getOid((String)value.get());
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.move(opContext.getDn(), opContext.getParent(), opContext.getNewRdn(), opContext.getDelOldDn(), entry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.metaSchemaHandler.move(opContext.getDn(), opContext.getParent(), opContext.getNewRdn(), opContext.getDelOldDn(), entry, cascade);
            this.updateSchemaModificationAttributes(opContext);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modifySchemaSubentry(ModifyOperationContext opContext, ServerEntry subentry, ServerEntry targetSubentry, boolean doCascadeModify) throws Exception {
        block5: for (Modification mod : opContext.getModItems()) {
            String opAttrOid = this.registries.getOidRegistry().getOid(mod.getAttribute().getId());
            ServerAttribute serverAttribute = (ServerAttribute)mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.modifyAddOperation(opContext, opAttrOid, (EntryAttribute)serverAttribute, doCascadeModify);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.modifyRemoveOperation(opContext, opAttrOid, (EntryAttribute)serverAttribute, doCascadeModify);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    throw new LdapOperationNotSupportedException("Modify REPLACE operations on schema subentries are not allowed: it's just silly to destroy and recreate so many \nschema entities that reside in schema operational attributes.  Instead use \na targeted combination of modify ADD and REMOVE operations.", ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            throw new IllegalStateException("Undefined modify operation: " + mod.getOperation());
        }
        if (opContext.getModItems().size() > 0) {
            this.updateSchemaModificationAttributes(opContext);
        }
    }

    public void modifySchemaSubentry(ModifyOperationContext opContext, LdapDN name, int modOp, ServerEntry mods, ServerEntry subentry, ServerEntry targetSubentry, boolean doCascadeModify) throws Exception {
        Set attributeTypes = mods.getAttributeTypes();
        switch (modOp) {
            case 1: {
                for (AttributeType attributeType : attributeTypes) {
                    this.modifyAddOperation(opContext, attributeType.getOid(), mods.get(attributeType), doCascadeModify);
                }
                break;
            }
            case 3: {
                for (AttributeType attributeType : attributeTypes) {
                    this.modifyRemoveOperation(opContext, attributeType.getOid(), mods.get(attributeType), doCascadeModify);
                }
                break;
            }
            case 2: {
                throw new LdapOperationNotSupportedException("Modify REPLACE operations on schema subentries are not allowed: it's just silly to destroy and recreate so many \nschema entities that reside in schema operational attributes.  Instead use \na targeted combination of modify ADD and REMOVE operations.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            default: {
                throw new IllegalStateException("Undefined modify operation: " + modOp);
            }
        }
        this.updateSchemaModificationAttributes(opContext);
    }

    public String getSchema(AbstractSchemaDescription desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return (String)((List)desc.getExtensions().get("X-SCHEMA")).get(0);
        }
        return "other";
    }

    private void modifyRemoveOperation(ModifyOperationContext opContext, String opAttrOid, EntryAttribute mods, boolean doCascadeModify) throws Exception {
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        SchemaChangeHandler handler = this.opAttr2handlerMap.get(opAttrOid);
        switch (index) {
            case 0: {
                ComparatorDescription[] comparatorDescriptions;
                MetaComparatorHandler comparatorHandler = (MetaComparatorHandler)handler;
                for (ComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    comparatorHandler.delete(comparatorDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete((OperationContext)opContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                MetaNormalizerHandler normalizerHandler = (MetaNormalizerHandler)handler;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    normalizerHandler.delete(normalizerDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete((OperationContext)opContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                MetaSyntaxCheckerHandler syntaxCheckerHandler = (MetaSyntaxCheckerHandler)handler;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    syntaxCheckerHandler.delete(syntaxCheckerDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete((OperationContext)opContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                Syntax[] syntaxes;
                MetaSyntaxHandler syntaxHandler = (MetaSyntaxHandler)handler;
                for (Syntax syntax : syntaxes = this.parsers.parseSyntaxes(mods)) {
                    syntaxHandler.delete(syntax, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                MetaMatchingRuleHandler matchingRuleHandler = (MetaMatchingRuleHandler)handler;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    matchingRuleHandler.delete(mr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                MetaAttributeTypeHandler atHandler = (MetaAttributeTypeHandler)handler;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    atHandler.delete(at, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                MetaObjectClassHandler ocHandler = (MetaObjectClassHandler)handler;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    ocHandler.delete(oc, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                MetaMatchingRuleUseHandler mruHandler = (MetaMatchingRuleUseHandler)handler;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    mruHandler.delete(mru, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                MetaDitStructureRuleHandler dsrHandler = (MetaDitStructureRuleHandler)handler;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    dsrHandler.delete(dsr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                MetaDitContentRuleHandler dcrHandler = (MetaDitContentRuleHandler)handler;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    dcrHandler.delete(dcr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                MetaNameFormHandler nfHandler = (MetaNameFormHandler)handler;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    nfHandler.delete(nf, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject(opContext, (SchemaObject)nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown index into handler array: " + index);
            }
        }
    }

    private void modifyAddOperation(ModifyOperationContext opContext, String opAttrOid, EntryAttribute mods, boolean doCascadeModify) throws Exception {
        if (doCascadeModify) {
            LOG.error(CASCADING_ERROR);
        }
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        SchemaChangeHandler handler = this.opAttr2handlerMap.get(opAttrOid);
        switch (index) {
            case 0: {
                ComparatorDescription[] comparatorDescriptions;
                MetaComparatorHandler comparatorHandler = (MetaComparatorHandler)handler;
                for (ComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    comparatorHandler.add(comparatorDescription);
                    this.subentryModifier.add((OperationContext)opContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                MetaNormalizerHandler normalizerHandler = (MetaNormalizerHandler)handler;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    normalizerHandler.add(normalizerDescription);
                    this.subentryModifier.add((OperationContext)opContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                MetaSyntaxCheckerHandler syntaxCheckerHandler = (MetaSyntaxCheckerHandler)handler;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    syntaxCheckerHandler.add(syntaxCheckerDescription);
                    this.subentryModifier.add((OperationContext)opContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                Syntax[] syntaxes;
                MetaSyntaxHandler syntaxHandler = (MetaSyntaxHandler)handler;
                for (Syntax syntax : syntaxes = this.parsers.parseSyntaxes(mods)) {
                    syntaxHandler.add(syntax);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                MetaMatchingRuleHandler matchingRuleHandler = (MetaMatchingRuleHandler)handler;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    matchingRuleHandler.add(mr);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                MetaAttributeTypeHandler atHandler = (MetaAttributeTypeHandler)handler;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    atHandler.add(at);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                MetaObjectClassHandler ocHandler = (MetaObjectClassHandler)handler;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    ocHandler.add(oc);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                MetaMatchingRuleUseHandler mruHandler = (MetaMatchingRuleUseHandler)handler;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    mruHandler.add(mru);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                MetaDitStructureRuleHandler dsrHandler = (MetaDitStructureRuleHandler)handler;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    dsrHandler.add(dsr);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                MetaDitContentRuleHandler dcrHandler = (MetaDitContentRuleHandler)handler;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    dcrHandler.add(dcr);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                MetaNameFormHandler nfHandler = (MetaNameFormHandler)handler;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    nfHandler.add(nf);
                    this.subentryModifier.addSchemaObject(opContext, (SchemaObject)nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown index into handler array: " + index);
            }
        }
    }

    private void updateSchemaModificationAttributes(OperationContext opContext) throws Exception {
        String modifiersName = opContext.getSession().getEffectivePrincipal().getJndiName().getNormName();
        String modifyTimestamp = DateUtils.getGeneralizedTime();
        ArrayList<Modification> mods = new ArrayList<Modification>(2);
        mods.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)new DefaultServerAttribute("schemaModifyTimestamp", this.registries.getAttributeTypeRegistry().lookup("schemaModifyTimestamp"), new String[]{modifyTimestamp})));
        mods.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)new DefaultServerAttribute("schemaModifiersName", this.registries.getAttributeTypeRegistry().lookup("schemaModifiersName"), new String[]{modifiersName})));
        LdapDN name = new LdapDN("cn=schemaModifications,ou=schema");
        name.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        opContext.modify(name, mods, SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS);
    }

    static {
        VALID_OU_VALUES.add("normalizers".toLowerCase());
        VALID_OU_VALUES.add("comparators".toLowerCase());
        VALID_OU_VALUES.add("syntaxCheckers".toLowerCase());
        VALID_OU_VALUES.add("syntaxes".toLowerCase());
        VALID_OU_VALUES.add("matchingRules".toLowerCase());
        VALID_OU_VALUES.add("matchingRuleUse".toLowerCase());
        VALID_OU_VALUES.add("attributeTypes".toLowerCase());
        VALID_OU_VALUES.add("objectClasses".toLowerCase());
        VALID_OU_VALUES.add("nameForms".toLowerCase());
        VALID_OU_VALUES.add("ditContentRules".toLowerCase());
        VALID_OU_VALUES.add("ditStructureRules".toLowerCase());
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(CollectiveAttributeInterceptor.class.getName());
        SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS = Collections.unmodifiableCollection(c);
    }
}

