/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.util.concurrent.TimeUnit;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCursorImpl
extends AbstractCursor<Response>
implements SearchCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private SearchFuture future;
    private long timeout;
    private TimeUnit timeUnit;
    private Response response;
    private boolean done;
    private SearchResultDone searchDoneResp;

    public SearchCursorImpl(SearchFuture future, long timeout, TimeUnit timeUnit) {
        LOG_CURSOR.debug("Creating SearchCursorImpl {}", (Object)this);
        this.future = future;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public boolean next() throws Exception {
        if (this.done) {
            return false;
        }
        try {
            if (this.future.isCancelled()) {
                this.response = null;
                this.done = true;
                return false;
            }
            this.response = this.future.get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException("The response queue has been emptied, no response was found.", e);
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            this.close(ldapException);
            throw ldapException;
        }
        if (this.response == null) {
            this.future.cancel(true);
            throw new LdapException("TimeOut occurred");
        }
        this.done = this.response instanceof SearchResultDone;
        if (this.done) {
            this.searchDoneResp = (SearchResultDone)this.response;
            this.response = null;
        }
        return !this.done;
    }

    @Override
    public Response get() throws Exception {
        if (!this.available()) {
            throw new InvalidCursorPositionException();
        }
        return this.response;
    }

    @Override
    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    @Override
    public boolean available() {
        return this.response != null;
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing SearchCursorImpl {}", (Object)this);
        this.close(null);
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing SearchCursorImpl {}", (Object)this);
        if (this.done) {
            super.close();
            return;
        }
        if (!this.future.isCancelled()) {
            this.future.cancel(true);
        }
        if (cause != null) {
            super.close(cause);
        } else {
            super.close();
        }
    }

    @Override
    public void after(Response element) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("after( Response element )")));
    }

    @Override
    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("afterLast()")));
    }

    @Override
    public void before(Response element) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("before( Response element )")));
    }

    @Override
    public void beforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("beforeFirst()")));
    }

    @Override
    public boolean first() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("first()")));
    }

    @Override
    public boolean last() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("last()")));
    }

    @Override
    public boolean previous() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("previous()")));
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isReferral() {
        return this.response instanceof SearchResultReference;
    }

    @Override
    public Referral getReferral() throws LdapException {
        if (this.isReferral()) {
            return ((SearchResultReference)this.response).getReferral();
        }
        throw new LdapException();
    }

    @Override
    public boolean isEntry() {
        return this.response instanceof SearchResultEntry;
    }

    @Override
    public Entry getEntry() throws LdapException {
        if (this.isEntry()) {
            return ((SearchResultEntry)this.response).getEntry();
        }
        throw new LdapException();
    }

    @Override
    public boolean isIntermediate() {
        return this.response instanceof IntermediateResponse;
    }

    @Override
    public IntermediateResponse getIntermediate() throws LdapException {
        if (this.isEntry()) {
            return (IntermediateResponse)this.response;
        }
        throw new LdapException();
    }
}

