/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.cursor;

import java.util.Comparator;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final Comparator<E> comparator;
    private final E singleton;

    public SingletonCursor(E singleton) {
        this(singleton, null);
    }

    public SingletonCursor(E singleton, Comparator<E> comparator) {
        LOG_CURSOR.debug("Creating SingletonCursor {}", (Object)this);
        this.singleton = singleton;
        this.comparator = comparator;
    }

    @Override
    public boolean available() {
        return this.onSingleton;
    }

    @Override
    public void before(E element) throws Exception {
        this.checkNotClosed("before()");
        if (this.comparator == null) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_02010_NO_COMPARATOR_CANT_MOVE_BEFORE, new Object[0]));
        }
        int comparison = this.comparator.compare(this.singleton, element);
        if (comparison < 0) {
            this.first();
        } else {
            this.beforeFirst();
        }
    }

    @Override
    public void after(E element) throws Exception {
        this.checkNotClosed("after()");
        if (this.comparator == null) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_02011_NO_COMPARATOR_CANT_MOVE_AFTER, new Object[0]));
        }
        int comparison = this.comparator.compare(this.singleton, element);
        if (comparison > 0) {
            this.first();
        } else {
            this.afterLast();
        }
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean isFirst() throws Exception {
        this.checkNotClosed("isFirst");
        return this.onSingleton;
    }

    @Override
    public boolean isLast() throws Exception {
        this.checkNotClosed("isLast");
        return this.onSingleton;
    }

    @Override
    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("isAfterLast");
        return this.afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("isBeforeFirst");
        return this.beforeFirst;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_02012_CANNOT_ACCESS_IF_BEFORE_FIRST, new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_02013_CANNOT_ACCESS_IF_AFTER_LAST, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing SingletonCursor {}", (Object)this);
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing SingletonCursor {}", (Object)this);
        super.close(cause);
    }
}

