/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.controls;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreControlCriticality
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlCriticality.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreControlCriticality() {
        super("Store the control criticality");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        CodecControl<Control> control = null;
        MessageDecorator<? extends Message> message = container.getMessage();
        control = message.getCurrentControl();
        BerValue value = tlv.getValue();
        try {
            control.setCritical(BooleanDecoder.parse(value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err(I18n.ERR_04100, Strings.dumpBytes(value.getData()), bde.getMessage()));
            throw new DecoderException(bde.getMessage());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Control criticality : " + control.isCritical());
        }
    }
}

