/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest;

import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitSearchRequest
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSearchRequest.class);

    public InitSearchRequest() {
        super("Init SearchRequest");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) {
        TLV tlv = container.getCurrentTLV();
        SearchRequestImpl internalSearchRequest = new SearchRequestImpl();
        internalSearchRequest.setMessageId(container.getMessageId());
        SearchRequestDecorator searchRequest = new SearchRequestDecorator(container.getLdapCodecService(), internalSearchRequest);
        searchRequest.setTlvId(tlv.getId());
        container.setMessage(searchRequest);
        LOG.debug("Search Request");
    }
}

