/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.shared.i18n.I18n;

public final class LongDecoder {
    private static final long[] MASK = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public static long parse(BerValue value, long min, long max) throws LongDecoderException {
        long result = LongDecoder.parseLong(value);
        if (result >= min && result <= max) {
            return result;
        }
        throw new LongDecoderException(I18n.err(I18n.ERR_00038_VALUE_NOT_IN_RANGE, min, max));
    }

    public static long parse(BerValue value) throws LongDecoderException {
        return LongDecoder.parseLong(value);
    }

    public static long parseLong(BerValue value) throws LongDecoderException {
        long result = 0L;
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new LongDecoderException(I18n.err(I18n.ERR_00039_0_BYTES_LONG_LONG, new Object[0]));
        }
        if (bytes.length > 8) {
            throw new LongDecoderException(I18n.err(I18n.ERR_00039_0_BYTES_LONG_LONG, new Object[0]));
        }
        for (int i = 0; i < bytes.length && i < 9; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -((result ^ 0xFFFFFFFFFFFFFFFFL) + 1L & MASK[bytes.length - 1]);
        }
        return result;
    }
}

